CREATE DATABASE IF NOT EXISTS virtualprint;
USE virtualprint;

CREATE TABLE usuarios(
idUsuario           int(255) auto_increment not null,
nombres             varchar(255),
apellidos           varchar(255),
email               varchar(255),
sexo                varchar(50),
fechaNacimiento     date,
estado              boolean,
role                int(50),
fechaCreado         datetime,
password            varchar(255),
CONSTRAINT pk_usuarios PRIMARY KEY(idUsuario)
)ENGINE=InnoDb;

CREATE TABLE direcciones(
idDireccion        int(255) auto_increment not null,
ciudad             varchar(255),
departamento       varchar(255),
detalle            varchar(255),
nota               varchar(255),
telefono	   varchar(255),
principal			 boolean,
fechaCreado        datetime,
idUsuario          int(255) not null,
CONSTRAINT  pk_direcciones PRIMARY KEY(idDireccion),
CONSTRAINT  fk_direcciones_usuarios FOREIGN KEY(idUsuario) REFERENCES usuarios(idUsuario)
)ENGINE=InnoDb;

CREATE TABLE productos(
idProducto        int(255) auto_increment not null,
nombre            varchar(255),
alias             varchar(255),
imagen            varchar(255),
estado            boolean,
precio            int(50),
fechaCreado       datetime,
CONSTRAINT  pk_productos PRIMARY KEY(idProducto)
)ENGINE=InnoDb;

CREATE TABLE categorias(
idCategoria        int(255) auto_increment not null,
detalleObj         text,
idProducto         int(255) not null,
CONSTRAINT  pk_categorias PRIMARY KEY(idCategoria),
CONSTRAINT  fk_categorias_productos FOREIGN KEY(idProducto) REFERENCES productos(idProducto)
)ENGINE=InnoDb;

CREATE TABLE precios(
idPrecio           int(255) auto_increment not null,
grupos				 int(255),
detalleObj         text,
estado             boolean,
idProducto         int(255) not null,
CONSTRAINT  pk_precios PRIMARY KEY(idPrecio),
CONSTRAINT  fk_precios_productos FOREIGN KEY(idProducto) REFERENCES productos(idProducto)
)ENGINE=InnoDb;

CREATE TABLE cupones(
idCupon           int(255) auto_increment not null,
titulo            varchar(255),
tipo              varchar(255),
estado            boolean,
valor             int(50),
CONSTRAINT  pk_cupones PRIMARY KEY(idCupon)
)ENGINE=InnoDb;

CREATE TABLE pedidos(
idPedido          int(255) auto_increment not null,
detalleObj        text,
fechaCreado       datetime,
estado            varchar(255),
valor             varchar(255),
envio			varchar(255),
idUsuario         int(255) not null,
idCupon           int(255),
CONSTRAINT  pk_pedidos PRIMARY KEY(idPedido),
CONSTRAINT  fk_pedidos_usuarios FOREIGN KEY(idUsuario) REFERENCES usuarios(idUsuario),
CONSTRAINT  fk_pedidos_cupones FOREIGN KEY(idCupon) REFERENCES cupones(idCupon)
)ENGINE=InnoDb;

CREATE TABLE plantillas(
idPlantilla       int(255) auto_increment not null,
prevObj           text,
detalleObj        text,
categoria         text,
fechaCreado       datetime,
estado            boolean,
aprobado          boolean,
idUsuario         int(255) not null,
idProducto        int(255) not null,
CONSTRAINT  pk_plantillas PRIMARY KEY(idPlantilla),
CONSTRAINT  fk_plantillas_usuarios FOREIGN KEY(idUsuario) REFERENCES usuarios(idUsuario),
CONSTRAINT  fk_plantillas_productos FOREIGN KEY(idProducto) REFERENCES productos(idProducto)
)ENGINE=InnoDb;

CREATE TABLE subplantillas(
idSubplantilla      int(255) auto_increment not null,
idPadre             int(255) not null,
orientacion         varchar(50),
indexP              int(50) not null,
detalleObj        text,
CONSTRAINT pk_subplantillas PRIMARY KEY(idSubplantilla)
)ENGINE=InnoDb;

CREATE TABLE favoritos(
idFavorito        int(255) auto_increment not null,
color             varchar(255),
orientacion       varchar(255),
fechaCreado       datetime,
idUsuario         int(255) not null,
idPlantilla       int(255) not null,
CONSTRAINT  pk_favoritos PRIMARY KEY(idFavorito),
CONSTRAINT  fk_favoritos_usuarios FOREIGN KEY(idUsuario) REFERENCES usuarios(idUsuario),
CONSTRAINT  fk_favoritos_plantillas FOREIGN KEY(idPlantilla) REFERENCES plantillas(idPlantilla)
)ENGINE=InnoDb;

CREATE TABLE disenos(
idDiseno          int(255) auto_increment not null,
detalleObj        text,
carObj            text,
browser           varchar(255),
fechaCreado       datetime,
carrito			boolean,
idUsuario         int(255) not null,
idPlantilla       int(255) not null,
CONSTRAINT  pk_disenos PRIMARY KEY(idDiseno),
CONSTRAINT  fk_disenos_usuarios FOREIGN KEY(idUsuario) REFERENCES usuarios(idUsuario),
CONSTRAINT  fk_disenos_plantillas FOREIGN KEY(idPlantilla) REFERENCES plantillas(idPlantilla)
)ENGINE=InnoDb;

CREATE TABLE tutoriales(
idTutorial        int(255) auto_increment not null,
titulo            varchar(255),
youtube           varchar(255),
estado            boolean,
fechaCreado       datetime,
CONSTRAINT  pk_tutoriales PRIMARY KEY(idTutorial)
)ENGINE=InnoDb;

CREATE TABLE promociones(
idPromocion       int(255) auto_increment not null,
imagen            varchar(255),
link              varchar(255),
estado            boolean,
fechaCreado       datetime,
CONSTRAINT  pk_promociones PRIMARY KEY(idPromocion)
)ENGINE=InnoDb;

CREATE TABLE iconos(
idIcono         int(255) auto_increment not null,
titulo          varchar(255),
viewBox         varchar(255),
codigo          text,
CONSTRAINT  pk_iconos PRIMARY KEY(idIcono)
)ENGINE=InnoDb;

CREATE TABLE decoradores(
idDecorador      int(255) auto_increment not null,
titulo           varchar(255),
viewBox          varchar(255),
codigo           text,
CONSTRAINT  pk_decoradores PRIMARY KEY(idDecorador)
)ENGINE=InnoDb;

CREATE TABLE blog(
idPublicacion       int(255) auto_increment not null,
titulo              varchar(255),
contenido           text,
imagen            varchar(255),
estado              boolean,
fechaCreado         datetime,
CONSTRAINT  pk_blog PRIMARY KEY(idPublicacion)
)ENGINE=InnoDb;

CREATE TABLE configuraciones(
idConfiguracion     int(255) auto_increment not null,
alias               varchar(255),
texto               text,
CONSTRAINT  pk_configuraciones PRIMARY KEY(idConfiguracion)
)ENGINE=InnoDb;

CREATE TABLE inventarios(
idInventario        int(255) auto_increment not null,
detalleObj        text,
idProducto        int(255) not null,
CONSTRAINT  pk_inventarios PRIMARY KEY(idInventario),
CONSTRAINT  fk_inventarios_productos FOREIGN KEY(idProducto) REFERENCES productos(idProducto)
)ENGINE=InnoDb;

CREATE TABLE calificaciones(
	idCalificacion        int(255) auto_increment not null,
	idPedido      	  int(255),
	calificacion 	 int(255),
	comentario	 text,
	estado              boolean,
	fechaCreado       datetime,
	CONSTRAINT  pk_calificaciones PRIMARY KEY(idCalificacion)
)ENGINE=InnoDb;


-- Creación de registros de prueba

INSERT INTO `usuarios` (`idUsuario`, `nombres`, `apellidos`, `email`, `sexo`, `fechaNacimiento`, `estado`, `role`, `fechaCreado`, `password`) VALUES ('1', 'Prueba', 'Prueba', 'prueba@prueba.com', 'Masculino', '2000-01-01 00:00:00', '0', '3', '2010-01-01 00:00:00', '655e786674d9d3e77bc05ed1de37b4b6bc89f788829f9f3c679e7687b410c89b');
INSERT INTO `usuarios` (`idUsuario`, `nombres`, `apellidos`, `email`, `sexo`, `fechaNacimiento`, `estado`, `role`, `fechaCreado`, `password`) VALUES ('2', 'Admin', 'Admin', 'admin@admin.com', 'Masculino', '2000-01-01 00:00:00', '1', '3', '2010-01-01 00:00:00', '8c6976e5b5410415bde908bd4dee15dfb167a9c873fc4bb8a81f6f2ab448a918');
INSERT INTO `productos` (`idProducto`, `nombre`, `alias`, `imagen`, `estado`, `precio`, `fechaCreado`) VALUES ('1', 'Prueba', 'prueba', 'prueba.png', '0', '0', '2000-01-01 00:00:00');
INSERT INTO `plantillas` (`idPlantilla`, `prevObj`, `detalleObj`, `categoria`, `fechaCreado`, `estado`, `aprobado`, `idUsuario`, `idProducto`) VALUES ('1', 'Prueba', 'Prueba', 'Prueba', '2000-01-01 00:00:00', '0', '0', '1', '1');