<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackBundle\Entity\Usuario;

class UsuarioController extends Controller {

	 //LISTAR USUARIOS
	public function listAction( Request $request) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);

		if($authCheck == true) {
			$repository = $this->getDoctrine()->getRepository('BackBundle:Usuario');
			$usuarios = $repository->findAll();
			$data = array("code" => 200, "msg" => "Usuarios listados.", "data" => $usuarios);

		}else {$data = array("code" => 400, "msg" => "No autorizado.");}
		return $helpers->json($data);
	}


	 //VER UN USUARIO
	public function viewAction(Request $request, $idUsuario) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400, "msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);

			if ($identity->role > 1) {
				$em = $this->getDoctrine()->getManager();
				$usuario = $em->getRepository("BackBundle:Usuario")->findOneBy(array(
					"idusuario" => $idUsuario
					));

				if(is_object($usuario)){

					$dateSet = $usuario->getFechacreado()->format('M j, Y g:i:s A');
					$usuario->setFechacreado($dateSet);

					$data = array("code" => 200, "msg" => "Usuario listado.", "data" => $usuario);

				} else {$data = array("code" => 400, "msg" => "No existe un usuario con ese ID.");}
			} else {$data = array("code" => 400, "msg" => "No tienes permiso para listar usuarios.");}
		} else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}


	 //CREAR USUARIO
	public function newAction(Request $request) {
		$helpers = $this->get("app.helpers");

		$json = $request->get("json", null);
		$params = json_decode($json);
		$data = array();

		if ($json != null) {

			$nombres = (isset($params->nombres) && ctype_alpha($params->nombres)) ? $params->nombres : null;
			$apellidos = (isset($params->apellidos) && ctype_alpha($params->apellidos)) ? $params->apellidos : null;
			$email = (isset($params->email)) ? $params->email : null;
			$sexo = (isset($params->sexo)) ? $params->sexo : null;
			$fechaNacimiento = (isset($params->fechanacimiento)) ? $params->fechanacimiento : null;
			$fechaCreado = new \Datetime("now");
			$estado = (isset($params->estado)) ? $params->estado : 1;
			$role = (isset($params->role)) ? $params->role : 1;
			$password = (isset($params->password)) ? $params->password : null;

			$emailContraint = new Assert\Email();
			$emailContraint->message = "El Email no es valido";
			$validate_email = $this->get("validator")->validate($email, $emailContraint);

			if ($email != null && count($validate_email) == 0 && $password != null) {

				$usuario = new Usuario();
				$usuario->setNombres($nombres);
				$usuario->setApellidos($apellidos);
				$usuario->setEmail($email);
				$usuario->setSexo($sexo);
				$usuario->setFechanacimiento($fechaNacimiento);
				$usuario->setFechacreado($fechaCreado);
				$usuario->setEstado($estado);
				$usuario->setRole($role);
					 //Cifrar Password
				$pwd = hash('sha256', $password);
				$usuario->setPassword($pwd);

				$em = $this->getDoctrine()->getManager();
				$isset_user = $em->getRepository("BackBundle:Usuario")->findBy(array(
					"email" => $email
					));

				if (count($isset_user) == 0) {
					$em->persist($usuario);
					$em->flush();
					$data = array("code" => 200,"msg" => "Usuario creado.");
				} else {$data = array("code" => 400,"msg" => "El Email ya esta en uso.");}
			}else{$data = array("code" => 400,"msg" => "Datos incorrectos.");}
		}else{$data = array("code" => 400,"msg" => "No se recibio informacion.");}
		return $helpers->json($data);
	}

	 //EDITAR USUARIO
	public function editAction(Request $request) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);

		if ($authCheck == true) {

			$identity = $helpers->authCheck($hash, true);
			$json = $request->get("json", null);
			$params = json_decode($json);
			$data = array("code" => 400,"msg" => "Error");

			if ($json != null) {
				$idUsuario = (isset($params->idusuario)) ? $params->idusuario : null;
				$nombres = (isset($params->nombres) && ctype_alpha($params->nombres)) ? $params->nombres : null;
				$apellidos = (isset($params->apellidos) && ctype_alpha($params->apellidos)) ? $params->apellidos : null;
				$email = (isset($params->email)) ? $params->email : null;
				$sexo = (isset($params->sexo)) ? $params->sexo : null;
				$fechaNacimiento = (isset($params->fechanacimiento)) ? $params->fechanacimiento : null;
				$estado = (isset($params->estado)) ? $params->estado : 1;
				$role = (isset($params->role)) ? $params->role : 1;
				$password = (isset($params->password)) ? $params->password : null;

				$emailContraint = new Assert\Email();
				$emailContraint->message = "El Email no es valido";
				$validate_email = $this->get("validator")->validate($email, $emailContraint);

				$em = $this->getDoctrine()->getManager();
				$usuario = $em->getRepository("BackBundle:Usuario")->findOneBy(array(
					"idusuario" => $idUsuario
				));

				if ($email != null && $idUsuario != null && count($validate_email) == 0) {

					$usuario->setNombres($nombres);
					$usuario->setApellidos($apellidos);
					$usuario->setEmail($email);
					$usuario->setSexo($sexo);
					$usuario->setFechanacimiento($fechaNacimiento);
					if($identity->role > 1){
						if($idUsuario != 1){
							$usuario->setEstado($estado);
						}
						$usuario->setRole($role);
					}
						  //Cifrar Password
					if($password != null){
						$pwd = hash('sha256', $password);
						$usuario->setPassword($pwd);
					}
					$em = $this->getDoctrine()->getManager();
					$isset_user = $em->getRepository("BackBundle:Usuario")->findBy(array(
						"email" => $email
						));


					$havePermition = false;
					if($identity->role > 1 ){$havePermition = true;}
					if($identity->sub == $idUsuario){
						if (count($isset_user) == 0 || $identity->email == $email){$havePermition = true;}
					}

					if($havePermition == true){
						$em->persist($usuario);
						$em->flush();
						$data = array("code" => 200,"msg" => "Usuario editado.");

					} else {$data = array("code" => 400,"msg" => "No tienes permisos para editar otro usuario.");}
				}else{$data = array("code" => 400,"msg" => "El Email o el ID de usuario no es correcto.");}
			}else{$data = array("code" => 400,"msg" => "No se han enviado parametros.");}
		} else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}

	 //CAMBIAR CONTRASEÑA
	public function changepassAction(Request $request) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);

		if ($authCheck == true) {

			$identity = $helpers->authCheck($hash, true);
			$json = $request->get("json", null);
			$params = json_decode($json);
			$data = array("code" => 400,"msg" => "Error");

			if ($json != null) {

				$idUsuario = (isset($params->idusuario)) ? $params->idusuario : null;
				$actContra = (isset($params->actcontra)) ? $params->actcontra : null;
				$nueContra = (isset($params->nuecontra)) ? $params->nuecontra : null;
				$cNueContra = (isset($params->cnuecontra)) ? $params->cnuecontra : null;

				$em = $this->getDoctrine()->getManager();
				$usuario = $em->getRepository("BackBundle:Usuario")->findOneBy(array(
					"idusuario" => $idUsuario
				));

				$psw = hash('sha256', $actContra);

				if ($usuario->getPassword() === $psw){

					if ($nueContra === $cNueContra) {

						$pwd = hash('sha256', $nueContra);
						$usuario->setPassword($pwd);
						$em->persist($usuario);
						$em->flush();

						$data = array("code" => 200,"msg" => "Contraseña actualizada.");

					}else{$data = array("code" => 400,"msg" => "Las contraseñas no coinciden.");}
				}else{$data = array("code" => 400,"msg" => "La contraseña es incorrecta.");}
			}
		}
		return $helpers->json($data);
	}


	 //ELIMINAR USUARIO
	public function deleteAction(Request $request, $idUsuario) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400, "msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);

			if ($identity->role > 1) {
				$em = $this->getDoctrine()->getManager();
				$usuario = $em->getRepository("BackBundle:Usuario")->findOneBy(array(
					"idusuario" => $idUsuario
					));


				if(is_object($usuario)){

						  //Llamar al usuario de prueba
					$usuarioPrueba = $em->getRepository("BackBundle:Usuario")->findOneBy(array(
						"idusuario" => 1
						));

						  //Eliminar direcciones asociadas
					$direcciones = $em->getRepository("BackBundle:Direccion")->findBy(array("idusuario" =>$usuario));
					if($direcciones) {
						foreach ($direcciones as $direccion) {$em->remove($direccion);};
						$em->flush();
					}

						  //Transladar los diseños al usuario de prueba
					$disenos = $em->getRepository("BackBundle:Diseno")->findBy(array("idusuario" =>$usuario));
					if($disenos) {
						foreach ($disenos as $diseno) {
							$diseno->setIdusuario($usuarioPrueba);
							$em->persist($diseno);
						};
						$em->flush();
					}

						  //Transladar los pedidos al usuario de prueba
					$pedidos = $em->getRepository("BackBundle:Pedido")->findBy(array("idusuario" =>$usuario));
					if($pedidos) {
						foreach ($pedidos as $pedido) {
							$pedido->setIdusuario($usuarioPrueba);
							$em->persist($pedido);
						};
						$em->flush();
					}

						  //Eliminar favoritos asociados
					$favoritos = $em->getRepository("BackBundle:Favorito")->findBy(array("idusuario" =>$usuario));
					if($favoritos) {
						foreach ($favoritos as $favorito) {$em->remove($favorito);};
						$em->flush();
					}

						  //Transladar las plantillas al usuario de prueba
					$plantillas = $em->getRepository("BackBundle:Plantilla")->findBy(array("idusuario" =>$usuario));
					if($plantillas) {
						foreach ($plantillas as $plantilla) {
							$plantilla->setIdusuario($usuarioPrueba);
							$em->persist($plantilla);
						};
						$em->flush();
					}


					$em->remove($usuario);
					$em->flush();
					$data = array("code" => 200, "msg" => "Usuario eliminado.");

				} else {$data = array("code" => 400, "msg" => "No existe un usuario con ese ID.");}
			} else {$data = array("code" => 400, "msg" => "No tienes permiso para eliminar usuarios.");}
		} else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}
}

