<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackBundle\Entity\Tutorial;

class TutorialController extends Controller {
    
    //LISTAR TUTORIALES
    public function listAction( Request $request) {
        $helpers = $this->get("app.helpers");
        $data = array("code" => 400, "msg" => "Error");

        
        $repository = $this->getDoctrine()->getRepository('BackBundle:Tutorial');
        $tutoriales = $repository->findAll();

        if($tutoriales) {
            foreach ($tutoriales as $tutorial){
                $dateSet = $tutorial->getFechacreado()->format('M j, Y g:i:s A');
                $tutorial->setFechacreado($dateSet);
            };
        }

        $data = array("code" => 200, "msg" => "Tutoriales listados.", "data" => $tutoriales);

        return $helpers->json($data);
    }
    
    //VER UN TUTORIAL
    public function viewAction(Request $request, $idTutorial) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400, "msg" => "Error");

         if($authCheck == true && $identity->role > 1 ) {

            $em = $this->getDoctrine()->getManager();
            $tutorial = $em->getRepository("BackBundle:Tutorial")->findOneBy(array("idtutorial" => $idTutorial));

            if(is_object($tutorial)){

                $dateSet = $tutorial->getFechacreado()->format('M j, Y g:i:s A');
                $tutorial->setFechacreado($dateSet);

                $data = array("code" => 200, "msg" => "Tutorial listado.", "data" => $tutorial); 

               

            } else {$data = array("code" => 400, "msg" => "No existe un tutorial con ese ID.");}   
        } else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }
    
    
    //CREAR TUTORIAL
    public function newAction(Request $request) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400,"msg" => "ERROR");

        if($authCheck == true && $identity->role > 1 ) {
            $json = $request->get("json", null);
            
            if ($json != null) {
                $params = json_decode($json);
                $titulo = (isset($params->titulo)) ? $params->titulo : null;
                $youtube = (isset($params->youtube)) ? $params->youtube : null;
                $estado = (isset($params->estado)) ? $params->estado : 0; 
                $fechaCreado = new \Datetime("now");   
                
                if($titulo != null){
                    
                   $tutorial = new Tutorial(); 
                   $tutorial->setTitulo($titulo);
                   $tutorial->setYoutube($youtube);
                   $tutorial->setEstado($estado);
                   $tutorial->setFechacreado($fechaCreado);
                   $em = $this->getDoctrine()->getManager();
                   $em->persist($tutorial);
                   $em->flush();
                   $data = array("code" => 200,"msg" => "Tutorial creado.");
                   
                } else {$data = array("code" => 400,"msg" => "Parametros incompletos.");}
            } else {$data = array("code" => 400,"msg" => "Parametros invalidos.");}
        } else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }
    
    
    //EDITAR TUTORIAL
    public function editAction(Request $request) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400,"msg" => "ERROR");

        if($authCheck == true && $identity->role > 1 ) {
            $json = $request->get("json", null);
            
            if ($json != null) {
                $params = json_decode($json);
                $idTutorial = (isset($params->idtutorial)) ? $params->idtutorial : null;
                $titulo = (isset($params->titulo)) ? $params->titulo : null;
                $youtube = (isset($params->youtube)) ? $params->youtube : null;
                $estado = (isset($params->estado)) ? $params->estado : 0;
                
                $em = $this->getDoctrine()->getManager();
                $tutorial = $em->getRepository("BackBundle:Tutorial")->findOneBy(array(
                    "idtutorial" => $idTutorial
                ));
                
                if(is_object($tutorial)){
                
                    if($titulo != null){

                       $tutorial->setTitulo($titulo);
                       $tutorial->setYoutube($youtube);
                       $tutorial->setEstado($estado);

                       $em->persist($tutorial);
                       $em->flush();
                       $data = array("code" => 200,"msg" => "Tutorial editado.");
                    
                    } else {$data = array("code" => 400,"msg" => "Parametros incompletos.");}
                } else {$data = array("code" => 400,"msg" => "No se encontro un tutorial con ese ID.");}
            } else {$data = array("code" => 400,"msg" => "Parametros invalidos.");}
        } else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }
    
    
    //ELIMINAR TUTORIAL
    public function deleteAction(Request $request, $idTutorial) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400,"msg" => "ERROR");

         if($authCheck == true && $identity->role > 1 ) {
            $em = $this->getDoctrine()->getManager();
            $tutorial = $em->getRepository("BackBundle:Tutorial")->findOneBy(array(
                "idtutorial" => $idTutorial
            ));
            
            if(is_object($tutorial)){
                
                $em->remove($tutorial);
                $em->flush();
                $data = array("code" => 200, "msg" => "Tutorial eliminado.");
                    
            }else{$data = array("code" => 400,"msg" => "No se encontro un tutorial con ese ID.");}  
        } else {$data = array("code" => 400,"msg" => "Autorizacion invalida");}
        return $helpers->json($data);
    }
}