<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackBundle\Entity\Subplantilla;
use BackBundle\Entity\Plantilla;

class SubplantillaController extends Controller {

	//VER UNA SUBPLANTILLA
	public function viewAction(Request $request, $idSubplantilla) {
		$helpers = $this->get("app.helpers");
		$data = array("code" => 400, "msg" => "Error");

		$em = $this->getDoctrine()->getManager();

		$subPlantilla = $em->getRepository("BackBundle:Subplantilla")->findOneBy(array(
			"idsubplantilla" => $idSubplantilla
		));

		if(is_object($subPlantilla)){

			$data = array("code" => 200, "msg" => "Subplantilla listada.", "data" => $subPlantilla);

		} else {$data = array("code" => 400, "msg" => "No existe una subplantilla con ese ID.");}
		return $helpers->json($data);
	}

	//VER SUBPLANTILLAS DE PLANTILLA PADRE
	public function subPlantillasdePadreAction(Request $request) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$json = $request->get("json", null);
		$data = array("code" => 400, "msg" => "Error");
		$em = $this->getDoctrine()->getManager();

		if ($authCheck == true) {

			if ($json != null) {
				$params = json_decode($json);

				$orientacion = (isset($params->orientacion)) ? $params->orientacion : null;
				$idPadre = (isset($params->idpadre)) ? $params->idpadre : null;

				$Plantilla = $em->getRepository("BackBundle:Plantilla")->findOneBy(array("idplantilla" => $idPadre));

				$subPlantillas = $em->getRepository("BackBundle:Subplantilla")->findBy(
					array("idpadre" => $idPadre,"orientacion" => $orientacion),
					array("indexp" => 'ASC')
				);

				if(is_object($Plantilla)){

					if(count($subPlantillas) > 0){

						$data = array("code" => 200, "msg" => "Subplantillas listadas.", "data" => $subPlantillas);

					} else {$data = array("code" => 400, "msg" => "No existen subplantillas de esa plantilla.");}
				} else {$data = array("code" => 400, "msg" => "No existen una plantilla con ese ID.");}
			} else {$data = array("code" => 400, "msg" => "Parametros invalidos.");}
		} else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}

	//TRAER SUBPLANTILLA SIN ID
	public function subPlantillaSinIdAction(Request $request) {
		$helpers = $this->get("app.helpers");
		$json = $request->get("json", null);
		$data = array("code" => 400, "msg" => "Error");
		$em = $this->getDoctrine()->getManager();

		if ($json != null) {

			$params = json_decode($json);
			$idPadre = (isset($params->idpadre)) ? $params->idpadre : null;
			$orientacion = (isset($params->orientacion)) ? $params->orientacion : null;
			$indexP = (isset($params->indexp)) ? $params->indexp : null;

			$Subplantilla = $em->getRepository("BackBundle:Subplantilla")->findOneBy(array(
				"idpadre" => $idPadre,
				"orientacion" => $orientacion,
				"indexp" => $indexP
				));

			if(is_object($Subplantilla)){

				$data = array("code" => 200, "msg" => "Subplantilla listada.", "data" => $Subplantilla);

			} else {$data = array("code" => 400, "msg" => "No existen una subplantilla con esas caracteristicas.");}
		} else {$data = array("code" => 400, "msg" => "Parametros invalidos.");}
		return $helpers->json($data);
	}


	//CREAR SUBPLANTILLAS
	public function newAction(Request $request) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400,"msg" => "ERROR");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);

			if($identity->role > 1){

				$json = $request->get("json", null);
				$params = json_decode($json);

				if ($json != null) {

					$detalleObj = (isset($params->detalleobj)) ? $params->detalleobj : null;
					$idPadre = (isset($params->idpadre)) ? $params->idpadre : null;
					$orientacion = (isset($params->orientacion)) ? $params->orientacion : null;
					$indexp = (isset($params->indexp)) ? $params->indexp : null;

					$em = $this->getDoctrine()->getManager();

					$Plantilla = $em->getRepository("BackBundle:Plantilla")->findOneBy(array("idplantilla" => $idPadre));

					if(is_object($Plantilla)){

						$subplantilla = new Subplantilla();
						$subplantilla->setIdpadre($idPadre);
						$subplantilla->setDetalleobj($detalleObj);
						$subplantilla->setOrientacion($orientacion);
						$subplantilla->setIndexp($indexp);

						$em->persist($subplantilla);
						$em->flush();
						$data = array("code" => 200,"msg" => "Subplantilla creada.");

					}else{$data = array("code" => 400,"msg" => "No existen una plantilla con ese ID.");}
				}else{$data = array("code" => 400,"msg" => "Parametros invalidos.");}
			}else{$data = array("code" => 400,"msg" => "No tienes permisos para crear plantillas.");}
		}else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}

	//EDITAR SUBPLANTILLAS
	public function editAction(Request $request) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400,"msg" => "ERROR");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);

			if($identity->role > 1){

				$json = $request->get("json", null);
				$params = json_decode($json);

				if ($json != null) {

					$idSubplantilla = (isset($params->idsubplantilla)) ? $params->idsubplantilla : null;
					$detalleObj = (isset($params->detalleobj)) ? $params->detalleobj : null;

					$em = $this->getDoctrine()->getManager();

					$subplantilla = $em->getRepository("BackBundle:Subplantilla")->findOneBy(array(
						"idsubplantilla" => $idSubplantilla
					));

					if(is_object($subplantilla)){

						$subplantilla->setDetalleobj($detalleObj);

						$em->persist($subplantilla);
						$em->flush();
						$data = array("code" => 200, "msg" => "Subplantilla editada.", "info" => $subplantilla);

					}else{$data = array("code" => 400,"msg" => "No se encontro una subplantilla con ese ID.");}
				}else{$data = array("code" => 400,"msg" => "Parametros invalidos.");}
			}else{$data = array("code" => 400,"msg" => "No tienes permisos para editar plantillas.");}
		}else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}
}