<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackBundle\Entity\Promocion;
 
class PromocionController extends Controller {
    
    //LISTAR PROMOCIONES
    public function listAction( Request $request) {
        $helpers = $this->get("app.helpers");
        // $hash = $request->get("authorization", null);
        // $authCheck = $helpers->authCheck($hash);
        // $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400, "msg" => "Error");


            
            $repository = $this->getDoctrine()->getRepository('BackBundle:Promocion');
            $promociones = $repository->findAll();

            if($promociones) {
                foreach ($promociones as $promocion){
                    $dateSet = $promocion->getFechacreado()->format('M j, Y g:i:s A');
                    $promocion->setFechacreado($dateSet);
                };
            }

            $data = array("code" => 200, "msg" => "Promociones listados.", "data" => $promociones);


        return $helpers->json($data);
    }
    
    //VER UNA PROMOCION
    public function viewAction(Request $request, $idPromocion) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400, "msg" => "Error");

         if($authCheck == true) {

            $em = $this->getDoctrine()->getManager();
            $promocion = $em->getRepository("BackBundle:Promocion")->findOneBy(array(
                "idpromocion" => $idPromocion
            ));

            if(is_object($promocion)){

                $dateSet = $promocion->getFechacreado()->format('M j, Y g:i:s A');
                $promocion->setFechacreado($dateSet);

                $data = array("code" => 200, "msg" => "Promocion listada.", "data" => $promocion); 
            } else {$data = array("code" => 400, "msg" => "No existe una promocion con ese ID.");}    
        } else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }
    
    
    //CREAR PROMOCION
    public function newAction(Request $request) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400,"msg" => "ERROR");

        if($authCheck == true && $identity->role > 1 ) {
            $json = $request->get("json", null);
            
            if ($json != null) {
                $params = json_decode($json);
                $link  = (isset($params->link)) ? $params->link : null;
                $estado = (isset($params->estado)) ? $params->estado : 0; 
                $fechaCreado = new \Datetime("now");
                $imagen = (isset($params->imagen)) ? $params->imagen : null; 

                $nombreImg = $fechaCreado->format('Y-m-d_H-i-s');

                if ($imagen != null) {
                    $baseFromJavascript = str_replace(' ', '+', $imagen);
                    $base_to_php = explode(',', $baseFromJavascript);
                    $data = base64_decode($base_to_php[1]);
                    $filepath = "uploads/imagenes/promociones/" . $nombreImg . ".png";
                    file_put_contents($filepath, $data);
                }  
 
               $promocion = new Promocion(); 
               $promocion->setLink($link);
               $promocion->setEstado($estado);
               $promocion->setFechacreado($fechaCreado);
               
               $em = $this->getDoctrine()->getManager();
               $em->persist($promocion);
               $em->flush();
               $data = array("code" => 200,"msg" => "Promocion creada.");
               
            } else {$data = array("code" => 400,"msg" => "Parametros invalidos.");}
        } else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }
    
    
    //EDITAR PROMOCION
    public function editAction(Request $request) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400,"msg" => "ERROR");

        if($authCheck == true && $identity->role > 1 ) {
            $json = $request->get("json", null);
            
            if ($json != null) {
                $params = json_decode($json);
                $idPromocion = (isset($params->idpromocion)) ? $params->idpromocion : null;
                $link  = (isset($params->link)) ? $params->link : null;
                $estado = (isset($params->estado)) ? $params->estado : 0; 
                $imagen = (isset($params->imagen)) ? $params->imagen : null; 
                
                $em = $this->getDoctrine()->getManager();
                $promocion = $em->getRepository("BackBundle:Promocion")->findOneBy(array(
                    "idpromocion" => $idPromocion
                ));

                if ($imagen != null) {
                    $nombreImg = $promocion->getFechacreado()->format('Y-m-d_H-i-s');
                    $baseFromJavascript = str_replace(' ', '+', $imagen);
                    $base_to_php = explode(',', $baseFromJavascript);
                    $data = base64_decode($base_to_php[1]);
                    $filepath = "uploads/imagenes/promociones/" . $nombreImg . ".png";
                    file_put_contents($filepath, $data);
                } 
                
                if(is_object($promocion)){

                   $promocion->setLink($link);
                   $promocion->setEstado($estado);

                   $em->persist($promocion);
                   $em->flush();
                   $data = array("code" => 200,"msg" => "Promocion editada.");
 
                } else {$data = array("code" => 400,"msg" => "No se encontro una promocion con ese ID.");}
            } else {$data = array("code" => 400,"msg" => "Parametros invalidos.");}
        } else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }
    
    
    //ELIMINAR TUTORIAL
    public function deleteAction(Request $request, $idPromocion) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400,"msg" => "ERROR");

         if($authCheck == true && $identity->role > 1 ) {
            $em = $this->getDoctrine()->getManager();
            $promocion = $em->getRepository("BackBundle:Promocion")->findOneBy(array(
                "idpromocion" => $idPromocion
            ));
            
            if(is_object($promocion)){

                $nombreImg = $promocion->getFechacreado()->format('Y-m-d_H-i-s');
                $existeIm = "uploads/imagenes/promociones/" . $nombreImg . ".png";
                if (file_exists($existeIm)){
                    unlink($existeIm);
                }

                $em->remove($promocion);
                $em->flush();
                $data = array("code" => 200, "msg" => "Promocion eliminada.");
                    
            }else{$data = array("code" => 400,"msg" => "No se encontro una promocion con ese ID.");}  
        } else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }
}