<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackBundle\Entity\Producto;

class ProductoController extends Controller {

    //LISTAR PRODUCTOS
    public function listAction( Request $request) {
        $helpers = $this->get("app.helpers");
        $data = array("code" => 400, "msg" => "Error");

        $repository = $this->getDoctrine()->getRepository('BackBundle:Producto');
        $productos = $repository->findAll();
        $data = array("code" => 200, "msg" => "Productos listados.", "data" => $productos);

        return $helpers->json($data);
    }

    //VER UN PRODUCTO
    public function viewAction(Request $request, $idProducto) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400, "msg" => "Error");

         if($authCheck == true) {

            $em = $this->getDoctrine()->getManager();
            $producto = $em->getRepository("BackBundle:Producto")->findOneBy(array("idproducto" => $idProducto));

            if(is_object($producto)){

                $dateSet = $producto->getFechacreado()->format('M j, Y g:i:s A');
                $producto->setFechacreado($dateSet);

                $data = array("code" => 200, "msg" => "Producto listado.", "data" => $producto);

            } else {$data = array("code" => 400, "msg" => "No existe un producto con ese ID.");}

        } else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }


    //CREAR PRODUCTO
    public function newAction(Request $request){
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $data = array("code" => 400,"msg" => "ERROR");

        if ($authCheck == true){
            $identity = $helpers->authCheck($hash, true);
            $json = $request->get("json", null);

            if ($json != null) {
                $params = json_decode($json);
                $nombre = (isset($params->nombre)) ? $params->nombre : null;
                $alias = (isset($params->alias)) ? $params->alias : null;
                $imagen = (isset($params->imagen)) ? $params->imagen : null;
                $estado = (isset($params->estado)) ? $params->estado : 1;
                $precio = (isset($params->precio)) ? $params->precio : null;
                $fechaCreado = new \Datetime("now");

                if($nombre != null && $alias != null && $precio != null){

                    $em = $this->getDoctrine()->getManager();
                    $producto = $em->getRepository("BackBundle:Producto")->findOneBy(array(
                        "alias" => $alias
                    ));

                    if(!is_object($producto)){

                        $producto = new Producto();
                        $producto->setNombre($nombre);
                        $producto->setAlias($alias);
                        $producto->setEstado($estado);
                        $producto->setPrecio($precio);
                        $producto->setFechacreado($fechaCreado);

                        if ($imagen != null) {
                            $baseFromJavascript = str_replace(' ', '+', $imagen);
                            $base_to_php = explode(',', $baseFromJavascript);
                            $data = base64_decode($base_to_php[1]);
                            $filepath = "uploads/imagenes/productos/" . $alias . ".png";
                            file_put_contents($filepath, $data);
                            $producto->setImagen($alias . ".png");
                        }else{$producto->setImagen($imagen);}


                        if($identity->role > 1){

                        $em->persist($producto);
                        $em->flush();
                        $data = array("code" => 200,"msg" => "Producto creado.");

                        }else{$data = array("code" => 400,"msg" => "No tienes permiso para crear productos.");}
                    }else{$data = array("code" => 400,"msg" => "Ya existe un producto con ese alias.");}
                }else{$data = array("code" => 400,"msg" => "No se enviaron los parametros necesarios.");}
            }else{$data = array("code" => 400,"msg" => "Parametros invalidos.");}
        }else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }


    //EDITAR PRODUCTO
    public function editAction(Request $request) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $data = array("code" => 400,"msg" => "ERROR");

        if ($authCheck == true) {
            $identity = $helpers->authCheck($hash, true);
            $json = $request->get("json", null);

            if ($json != null) {
                $params = json_decode($json);
                $idProducto = (isset($params->idproducto)) ? $params->idproducto : null;
                $nombre = (isset($params->nombre)) ? $params->nombre : null;
                $alias = (isset($params->alias)) ? $params->alias : null;
                $imagen = (isset($params->imagen)) ? $params->imagen : null;
                $estado = (isset($params->estado)) ? $params->estado : 1;
                $precio = (isset($params->precio)) ? $params->precio : null;

                if($alias != null){

                    $em = $this->getDoctrine()->getManager();

                    $producto = $em->getRepository("BackBundle:Producto")->findOneBy(array(
                        "idproducto" => $idProducto
                    ));

                    $aliasProd = $em->getRepository("BackBundle:Producto")->findOneBy(array(
                        "alias" => $alias
                    ));

                    if(!is_object($aliasProd) || $producto->getAlias() == $alias){

                        if(is_object($producto)){

                            if($producto->getAlias() != $alias){
                                $oldIm = "uploads/imagenes/productos/" . $producto->getimagen();
                                $newIm = "uploads/imagenes/productos/" . $alias . ".png";

                                if (file_exists($oldIm)){
                                rename($oldIm, $newIm);
                                }
                                $producto->setAlias($alias);
                                $producto->setImagen($alias . ".png");
                            }

                            $producto->setNombre($nombre);
                            $producto->setEstado($estado);
                            $producto->setPrecio($precio);

                            if ($producto->getImagen() != $imagen && $imagen != null) {
                                $existeIm = "uploads/imagenes/productos/" . $producto->getimagen();
                                $newImg = "uploads/imagenes/productos/" . $alias . ".png";
                                if (file_exists($existeIm)){
                                    rename($existeIm, $newImg);
                                }
                                $baseFromJavascript = str_replace(' ', '+', $imagen);
                                $base_to_php = explode(',', $baseFromJavascript);
                                $data = base64_decode($base_to_php[1]);
                                $filepath = "uploads/imagenes/productos/" . $alias . ".png";
                                file_put_contents($filepath, $data);
                                $producto->setImagen($alias . ".png");
                            }else{$producto->setImagen($imagen);}

                           if($identity->role > 1){
                            $em->persist($producto);
                            $em->flush();
                            $data = array("code" => 200,"msg" => "Producto editado.");

                            }else{$data = array("code" => 400,"msg" => "No tienes permiso para editar productos.");}
                        }else{$data = array("code" => 400,"msg" => "No se encontro un producto con ese ID.");}
                    }else{$data = array("code" => 400,"msg" => "Ya existe un producto con ese alias.");}
                }else{$data = array("code" => 400,"msg" => "No se enviaron los parametros necesarios.");}
            }else{$data = array("code" => 400,"msg" => "Parametros invalidos.");}
        } else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
         return $helpers->json($data);
    }


    //ELIMINAR PRODUCTO
    public function deleteAction(Request $request, $idProducto) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $data = array("code" => 400,"msg" => "ERROR");

        if ($authCheck == true) {
            $identity = $helpers->authCheck($hash, true);
            $em = $this->getDoctrine()->getManager();
            $producto = $em->getRepository("BackBundle:Producto")->findOneBy(array(
                "idproducto" => $idProducto
            ));

            if(is_object($producto)){

                //Eliminar categorias asociadas
                $categorias = $em->getRepository("BackBundle:Categoria")->findBy(array("idproducto" => $producto));
                if($categorias) {
                    foreach ($categorias as $categoria) {$em->remove($categoria);};
                    $em->flush();
                }

                //Eliminar precios asociadas
                $precios = $em->getRepository("BackBundle:Precio")->findBy(array("idproducto" => $producto));
                if($precios) {
                    foreach ($precios as $precio) {$em->remove($precio);};
                    $em->flush();
                }

                //Eliminar plantillas asociadas
                $plantillas = $em->getRepository("BackBundle:Plantilla")->findBy(array("idproducto" => $producto));
                if($plantillas) {
                    foreach ($plantillas as $plantilla) {$em->remove($plantilla);};
                    $em->flush();
                }

                //Eliminar inventarios asociadas
                $inventarios = $em->getRepository("BackBundle:Inventario")->findBy(array("idproducto" => $producto));
                if($inventarios) {
                    foreach ($inventarios as $inventario) {$em->remove($inventario);};
                    $em->flush();
                }


                if ($identity->role > 1) {

                    $em->remove($producto);
                    $em->flush();

                     $existeIm = "uploads/imagenes/productos/" . $producto->getimagen();
                    if (file_exists($existeIm)){
                        unlink($existeIm);
                    }

                    $data = array("code" => 200, "msg" => "Producto eliminado.");

                }else{$data = array("code" => 400,"msg" => "No tienes permiso para eliminar productos.");}
            }else{$data = array("code" => 400,"msg" => "No se encontro un producto con ese ID.");}
        } else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }
}
