<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackBundle\Entity\Producto;
use BackBundle\Entity\Precio;

class PrecioController extends Controller {

  //LISTAR PRECIOS
	public function listAction( Request $request) {
		$helpers = $this->get("app.helpers");
		$data = array("code" => 400, "msg" => "Error");

		$repository = $this->getDoctrine()->getRepository('BackBundle:Precio');
		$precios = $repository->findAll();
		$data = array("code" => 200, "msg" => "Precios listados.", "data" => $precios);

		return $helpers->json($data);
	}

	//VER UN PRECIO
	public function viewAction(Request $request, $idPrecio) {
		$helpers = $this->get("app.helpers");
		$data = array("code" => 400, "msg" => "Error");

		$em = $this->getDoctrine()->getManager();
		$precio = $em->getRepository("BackBundle:Precio")->findOneBy(array("idprecio" => $idPrecio));

		if(is_object($precio)){

			$data = array("code" => 200, "msg" => "Precio listado.", "data" => $precio);

		} else {$data = array("code" => 400, "msg" => "No existe un precio con ese ID.");}

		return $helpers->json($data);
	}

	  //VER PRCIO DE PRODUCTO
	public function viewpdpAction(Request $request, $aliasProducto) {
		$helpers = $this->get("app.helpers");
		$data = array("code" => 400, "msg" => "Error");

		$em = $this->getDoctrine()->getManager();

		$producto = $em->getRepository("BackBundle:Producto")->findOneBy(array("alias" => $aliasProducto));

		if (is_object($producto)) {

			$precio = $em->getRepository("BackBundle:Precio")->findOneBy(array("idproducto" => $producto->getIdproducto()));

			if(is_object($precio)){
				$data = array("code" => 200, "msg" => "Precio de producto listado.", "data" => $precio);
			} else {$data = array("code" => 400, "msg" => "No existe un precio para ese producto.");}

		} else {$data = array("code" => 400, "msg" => "No existe un producto con ese alias.");}
		return $helpers->json($data);
	}


	 //CREAR PRECIO
	public function newAction(Request $request) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400,"msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);
			$json = $request->get("json", null);

			if ($json != null) {
				$params = json_decode($json);

				if($identity->role > 1){

					$grupos = (isset($params->grupos)) ? $params->grupos : null;
					$detalleObj = (isset($params->detalleobj)) ? $params->detalleobj : null;
					$estado = (isset($params->estado)) ? $params->estado : 1;
					$idProducto = (isset($params->idproducto)) ? $params->idproducto : null;

					$em = $this->getDoctrine()->getManager();
					$producto = $em->getRepository("BackBundle:Producto")->findOneBy(array(
						"idproducto" => $idProducto
						));

					$precioDeProd = $em->getRepository("BackBundle:Precio")->findOneBy(array(
						"idproducto" => $producto
						));

					if($precioDeProd == null){

						if(is_object($producto)){

							$precio = new Precio();
							$precio->setGrupos($grupos);
							$precio->setDetalleobj($detalleObj);
							$precio->setEstado($estado);
							$precio->setIdproducto($producto);
							$em->persist($precio);
							$em->flush();
							$data = array("code" => 200,"msg" => "Precio creado.");

						} else {$data = array("code" => 400,"msg" => "No se encontro un producto con ese ID.");}
					}else{$data = array("code" => 400,"msg" => "Ese producto ya tiene asignado un grupo de precios.");}
				} else{$data = array("code" => 400,"msg" => "No tienes permiso para crear precios.");}
			} else {$data = array("code" => 400,"msg" => "Parametros invalidos.");}
		} else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}

 //EDITAR PRECIO
	public function editAction(Request $request) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400,"msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);
			$json = $request->get("json", null);

			if ($json != null) {
				$params = json_decode($json);

				if($identity->role > 1){

					$grupos = (isset($params->grupos)) ? $params->grupos : null;
					$idPrecio = (isset($params->idprecio)) ? $params->idprecio : null;
					$detalleObj = (isset($params->detalleobj)) ? $params->detalleobj : null;
					$estado = (isset($params->estado)) ? $params->estado : 1;
					$idProducto = (isset($params->idproducto)) ? $params->idproducto : null;

					$em = $this->getDoctrine()->getManager();

					$precio = $em->getRepository("BackBundle:Precio")->findOneBy(array(
						"idprecio" => $idPrecio
						));

					$producto = $em->getRepository("BackBundle:Producto")->findOneBy(array(
						"idproducto" => $idProducto
						));

					$precioDeProd = $em->getRepository("BackBundle:Precio")->findOneBy(array(
						"idproducto" => $producto
						));

					$difVal = false;
					if($precioDeProd == null || $precio->getidProducto()->getidProducto() == $idProducto){
						$difVal = true;
					}

					if(is_object($producto)){
						$precio->setIdproducto($producto);
					}


					if($difVal == true || $idProducto == 1){

						if(is_object($precio)){

							$precio->setGrupos($grupos);
							$precio->setDetalleobj($detalleObj);
							$precio->setEstado($estado);
							$em->persist($precio);
							$em->flush();
							$data = array("code" => 200,"msg" => "Precio editado.");

						}else{$data = array("code" => 400,"msg" => "No se encontro un precio con ese ID.");}
					}else{$data = array("code" => 400,"msg" => "Ese producto ya tiene asignado un grupo de precios.");}
				} else{$data = array("code" => 400,"msg" => "No tienes permiso para editar precios.");}
			} else {$data = array("code" => 400,"msg" => "Parametros invalidos.");}
		} else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}


	 //ELIMINAR PRECIOS
	public function deleteAction(Request $request, $idPrecio) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400, "msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);

			if ($identity->role > 1) {
				$em = $this->getDoctrine()->getManager();
				$precio = $em->getRepository("BackBundle:Precio")->findOneBy(array(
					"idprecio" => $idPrecio
					));

				if(is_object($precio)){
					$em->remove($precio);
					$em->flush();
					$data = array("code" => 200, "msg" => "Precio eliminado.");

				} else {$data = array("code" => 400, "msg" => "No existe un precio con ese ID.");}
			} else {$data = array("code" => 400, "msg" => "No tienes permiso para eliminar precios.");}
		} else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}

}
