<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackBundle\Entity\Usuario;
use BackBundle\Entity\Producto;
use BackBundle\Entity\Plantilla;

class PlantillaController extends Controller {

    //LISTAR PLANTILLAS
    public function listAction( Request $request) {
        $helpers = $this->get("app.helpers");
        $data = array("code" => 400, "msg" => "Error");
        $repository = $this->getDoctrine()->getRepository('BackBundle:Plantilla');
        $plantillas = $repository->findAll();

        if($plantillas) {
            foreach ($plantillas as $plantilla){
                $dateSet = $plantilla->getFechacreado()->format('M j, Y g:i:s A');
                $plantilla->setFechacreado($dateSet);
            };
        }
        $data = array("code" => 200, "msg" => "Plantillas listadas.", "data" => $plantillas);

        return $helpers->json($data);
    }

    //VER PLANTILLAS DE UN USUARIO
    public function plantillasDeUsuarioAction(Request $request, $idUsuario) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $data = array("code" => 400, "msg" => "Error");
        $em = $this->getDoctrine()->getManager();

        if ($authCheck == true) {

            $usuario = $em->getRepository("BackBundle:Usuario")->findOneBy(array("idusuario" => $idUsuario));

            $plantillas = $em->getRepository("BackBundle:Plantilla")->findBy(array("idusuario" => $usuario));

            if(count($plantillas) > 0){

                $data = array("code" => 200, "msg" => "Plantillas de usuario listadas.", "data" => $plantillas);

            } else {$data = array("code" => 400, "msg" => "No existen plantillas de ese usuario.");}
        } else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}

        return $helpers->json($data);
    }

    //VER PLANTILLAS DE UN PRODUCTO
    public function plantillasDeProductoAction(Request $request, $aliasProducto) {
        $helpers = $this->get("app.helpers");
        // $hash = $request->get("authorization", null);
        // $authCheck = $helpers->authCheck($hash);
        $data = array("code" => 400, "msg" => "Error");
        $em = $this->getDoctrine()->getManager();

        // if ($authCheck == true) {

            $producto = $em->getRepository("BackBundle:Producto")->findOneBy(array("alias" => $aliasProducto));

            $plantillas = $em->getRepository("BackBundle:Plantilla")->findBy(array("idproducto" => $producto));

            if(count($plantillas) > 0){

                $data = array("code" => 200, "msg" => "Plantillas de producto listadas.", "data" => $plantillas);

            } else {$data = array("code" => 400, "msg" => "No existen plantillas de ese producto.");}
        // } else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}

        return $helpers->json($data);
    }


    //VER UNA PLANTILLA
    public function viewAction(Request $request, $idPlantilla) {
        $helpers = $this->get("app.helpers");
        $data = array("code" => 400, "msg" => "Error");

            $em = $this->getDoctrine()->getManager();
            $plantilla = $em->getRepository("BackBundle:Plantilla")->findOneBy(array(
                "idplantilla" => $idPlantilla
            ));

            if(is_object($plantilla)){

                $dateSet = $plantilla->getFechacreado()->format('M j, Y g:i:s A');
                $plantilla->setFechacreado($dateSet);

                $data = array("code" => 200, "msg" => "Plantilla listada.", "data" => $plantilla);

            } else {$data = array("code" => 400, "msg" => "No existe una plantilla con ese ID.");}
        return $helpers->json($data);
    }

    //CREAR PLANTILLAS
    public function newAction(Request $request) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $data = array("code" => 400,"msg" => "ERROR");

        if ($authCheck == true) {
            $identity = $helpers->authCheck($hash, true);

            if($identity->role > 1){

                $json = $request->get("json", null);
                $params = json_decode($json);

                if ($json != null) {

                    $prevObj = (isset($params->prevobj)) ? $params->prevobj : null;
                    $detalleObj = (isset($params->detalleobj)) ? $params->detalleobj : null;
                    $categoria = (isset($params->categoria)) ? $params->categoria : null;
                    $fechaCreado = new \Datetime("now");
                    $estado = (isset($params->estado)) ? $params->estado : 0;
                    $aprobado = (isset($params->aprobado)) ? $params->aprobado : 0;
                    $idUsuario = (isset($params->idusuario)) ? $params->idusuario : null;
                    $idProducto = (isset($params->idproducto)) ? $params->idproducto : null;

                    if ($identity->role < 3) {$idUsuario = $identity->sub;}

                    $em = $this->getDoctrine()->getManager();

                    $producto = $em->getRepository("BackBundle:Producto")->findOneBy(array(
                        "idproducto" => $idProducto
                    ));

                    $usuario = $em->getRepository("BackBundle:Usuario")->findOneBy(array(
                        "idusuario" => $idUsuario
                    ));

                    if(is_object($usuario)){

                        if(is_object($producto)){

                            $plantilla = new Plantilla();
                            $plantilla->setPrevobj($prevObj);
                            $plantilla->setDetalleobj($detalleObj);
                            $plantilla->setCategoria($categoria);
                            $plantilla->setFechacreado($fechaCreado);
                            $plantilla->setEstado($estado);
                            $plantilla->setAprobado($aprobado);
                            $plantilla->setIdusuario($usuario);
                            $plantilla->setIdproducto($producto);

                            $em->persist($plantilla);
                            $em->flush();
                            $data = array("code" => 200,"msg" => "Plantilla creada.", "id" =>  $plantilla->getIdplantilla());

                        }else{$data = array("code" => 400,"msg" => "No se encontro un producto con ese ID.");}
                    }else{$data = array("code" => 400,"msg" => "No se encontro un usuario con ese ID.");}
                }else{$data = array("code" => 400,"msg" => "Parametros invalidos.");}
            }else{$data = array("code" => 400,"msg" => "No tienes permisos para crear plantillas.");}
        }else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }

    //EDITAR PLANTILLAS
    public function editAction(Request $request) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $data = array("code" => 400,"msg" => "ERROR");

        if ($authCheck == true) {
            $identity = $helpers->authCheck($hash, true);

            if($identity->role > 1){

                $json = $request->get("json", null);
                $params = json_decode($json);

                if ($json != null) {

                    $idPlantilla = (isset($params->idplantilla)) ? $params->idplantilla : null;
                    $prevObj = (isset($params->prevobj)) ? $params->prevobj : null;
                    $detalleObj = (isset($params->detalleobj)) ? $params->detalleobj : null;
                    $categoria = (isset($params->categoria)) ? $params->categoria : null;
                    $estado = (isset($params->estado)) ? $params->estado : 0;
                    $aprobado = (isset($params->aprobado)) ? $params->aprobado : 0;
                    $idUsuario = (isset($params->idusuario)) ? $params->idusuario : null;
                    $idProducto = (isset($params->idproducto)) ? $params->idproducto : null;

                    $em = $this->getDoctrine()->getManager();

                    $plantilla = $em->getRepository("BackBundle:Plantilla")->findOneBy(array(
                        "idplantilla" => $idPlantilla
                    ));

                   $producto = $em->getRepository("BackBundle:Producto")->findOneBy(array(
                        "idproducto" => $idProducto
                    ));

                    $usuario = $em->getRepository("BackBundle:Usuario")->findOneBy(array(
                        "idusuario" => $idUsuario
                    ));


                    if(is_object($plantilla)){

                        if($plantilla->getidProducto()->getidProducto() != $idProducto && is_object($producto)){
                            $plantilla->setIdproducto($producto);
                        }

                        if($plantilla->getidUsuario()->getidUsuario() != $idUsuario && is_object($usuario) && $identity->role > 2){
                            $plantilla->setIdusuario($usuario);
                        }

                        if ($prevObj) {
                            $plantilla->setPrevobj($prevObj);
                        }
                        if ($detalleObj) {
                            $plantilla->setDetalleobj($detalleObj);
                        }
                        if ($categoria) {
                            $plantilla->setCategoria($categoria);
                        }
                        if ($estado) {
                            $plantilla->setEstado($estado);
                        }
                        if ($aprobado) {
                            $plantilla->setAprobado($aprobado);
                        }

                        $em->persist($plantilla);
                        $em->flush();
                        $data = array("code" => 200,"msg" => "Plantilla editada.");

                    }else{$data = array("code" => $idPlantilla,"msg" => "No se encontro una plantilla con ese ID.");}
                }else{$data = array("code" => 400,"msg" => "Parametros invalidos.");}
            }else{$data = array("code" => 400,"msg" => "No tienes permisos para editar plantillas.");}
        }else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }

    //ELIMINAR PLANTILLAS
    public function deleteAction(Request $request, $idPlantilla) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $data = array("code" => 400, "msg" => "Error");

        if ($authCheck == true) {
            $identity = $helpers->authCheck($hash, true);

            if($identity->role > 1){

                $em = $this->getDoctrine()->getManager();
                $plantilla = $em->getRepository("BackBundle:Plantilla")->findOneBy(array("idplantilla" => $idPlantilla));

                if(is_object($plantilla)){

                    //Llamar la plantilla de prueba
                    $plantillaPrueba = $em->getRepository("BackBundle:Plantilla")->findOneBy(array(
                    "idplantilla" => 1
                    ));


                    //Transladar los diseños a la plantilla de prueba
                    $disenos = $em->getRepository("BackBundle:Diseno")->findBy(array("idplantilla" =>$plantilla));
                    if($disenos) {
                        foreach ($disenos as $diseno) {
                            $diseno->setIdplantilla($plantillaPrueba);
                            $em->persist($diseno);
                        };
                        $em->flush();
                    }

                    //Eliminar favoritos asociados
                    $favoritos = $em->getRepository("BackBundle:Favorito")->findBy(array("idplantilla" =>$plantilla));
                    if($favoritos) {
                        foreach ($favoritos as $favorito) {$em->remove($favorito);};
                        $em->flush();
                    }

                    //Eliminar subplantillas
                    $subplantillas = $em->getRepository("BackBundle:Subplantilla")->findBy(array("idpadre" =>$idPlantilla));
                    if($subplantillas) {
                        foreach ($subplantillas as $subplantilla) {$em->remove($subplantilla);};
                        $em->flush();
                    }

                    $ruta = "uploads/imagenes/plantillas/miniaturas/".$idPlantilla;
                    if (file_exists($ruta)) {
                        foreach(glob($ruta."/*.*") as $obj){unlink($obj);
                        }
                        rmdir($ruta);
                    }

                    $ruta2 = "uploads/imagenes/plantillas/asignaciones/".$idPlantilla."/resources";
                    if (file_exists($ruta2)) {
                        foreach(glob($ruta2."/*.*") as $obj){unlink($obj);
                        }
                        rmdir($ruta2);
                    }

                    $ruta3 = "uploads/imagenes/plantillas/asignaciones/".$idPlantilla;
                    if (file_exists($ruta3)) {
                        foreach(glob($ruta3."/*.*") as $obj){unlink($obj);
                        }
                        rmdir($ruta3);
                    }



                    $em->remove($plantilla);
                    $em->flush();
                    $data = array("code" => 200, "msg" => "Plantilla eliminada.");

                } else {$data = array("code" => 400, "msg" => "No existe una plantilla con ese ID.");}
            }else{$data = array("code" => 400,"msg" => "No tienes permisos para eliminar plantillas.");}
        } else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }
}