<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackBundle\Entity\Usuario;
use BackBundle\Entity\Cupon;
use BackBundle\Entity\Pedido;

class PedidoController extends Controller {

	//GENERAR REFERENCIA
	public function referenceAction(Request $request) {
		$em = $this->getDoctrine()->getManager();
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400, "msg" => "Error");

		do {
			$ref = $helpers->generateReference();
			$existingRef = $em->getRepository("BackBundle:Pedido")->findOneBy(array(
				"referencia" => $ref
			));
		} while (is_object($existingRef));

		$data = array("code" => 200, "msg" => "Referencia generada", "data" => $ref);

		return $helpers->json($data);
	}

	//LISTAR PEDIDOS POR ESTADO
	public function listByStatusAction(Request $request, $estado) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400, "msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);

			if ($identity->role > 1) {
				$em = $this->getDoctrine()->getManager();
				$pedidos = $em->getRepository("BackBundle:Pedido")->findBy(array(
					"estado" => $estado
				));

				if(count($pedidos) > 0){

					$data = array("code" => 200, "msg" => "Categorias listadas", "data" => $pedidos);

				} else {$data = array("code" => 400, "msg" => 'No existen pedidos con ese estado.');}
			} else {$data = array("code" => 400, "msg" => "No tienes permiso para listar pedidos.");}
		} else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}

	//LISTAR PEDIDOS DE UN USUARIO
	public function listUserAction(Request $request, $idUsuario) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400, "msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);

			$em = $this->getDoctrine()->getManager();
			$pedidos = $em->getRepository("BackBundle:Pedido")->findBy(array(
				"idusuario" => $idUsuario
			));

			if($pedidos) {
				foreach ($pedidos as $pedido){
					$dateSet = $pedido->getFechacreado()->format('M j, Y g:i:s A');
					$pedido->setFechacreado($dateSet);
				};
			}

			if(count($pedidos) > 0){

				$data = array("code" => 200, "msg" => "Pedidos listados", "data" => $pedidos);

			} else {$data = array("code" => 400, "msg" => "No existen pedidos de ese usuario.");}

		} else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}

	//LISTAR EL ULTIMO PEDIDO DE UN USUARIO
	public function lastOfUserAction(Request $request, $idUsuario) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400, "msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);

			$em = $this->getDoctrine()->getManager();

			$usuario = $em->getRepository("BackBundle:Usuario")->findOneBy(array("idusuario" => $idUsuario));

			$pedido = $em->getRepository("BackBundle:Pedido")->findOneBy(
				array('idusuario'=>$usuario),
				array('idpedido' => 'DESC')
			);

			if(is_object($pedido)){

				$dateSet = $pedido->getFechacreado()->format('M j, Y g:i:s A');
				$pedido->setFechacreado($dateSet);
				$data = array("code" => 200, "msg" => "Pedido listado.", "data" => $pedido);

			} else {$data = array("code" => 400, "msg" => "No existen pedidos para ese usuario.");}
		} else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}

	//LISTAR PEDIDOS
	public function listAction(Request $request) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);

		if($authCheck == true) {
			$repository = $this->getDoctrine()->getRepository('BackBundle:Pedido');
			$pedidos = $repository->findAll();

			if($pedidos) {
				foreach ($pedidos as $pedido){
					$dateSet = $pedido->getFechacreado()->format('M j, Y g:i:s A');
					$pedido->setFechacreado($dateSet);
				};
			}

			$data = array("code" => 200, "msg" => "Pedidos listados.", "data" => $pedidos);

		}else {$data = array("code" => 400, "msg" => "No autorizado.");}
		return $helpers->json($data);
	}


	//VER UN PEDIDO
	public function viewAction(Request $request, $idPedido) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400, "msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);

			if ($identity->role > 1) {
				$em = $this->getDoctrine()->getManager();
				$pedido = $em->getRepository("BackBundle:Pedido")->findOneBy(array(
					"idpedido" => $idPedido
				));

				if(is_object($pedido)){

					$dateSet = $pedido->getFechacreado()->format('M j, Y g:i:s A');
					$pedido->setFechacreado($dateSet);

					$data = array("code" => 200, "msg" => "Pedido listado.", "data" => $pedido);

				} else {$data = array("code" => 400, "msg" => "No existe un pedido con ese ID.");}
			} else {$data = array("code" => 400, "msg" => "No tienes permiso para listar pedidos.");}
		} else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}


	//CREAR PEDIDOS
	public function newAction(Request $request) {
		$em = $this->getDoctrine()->getManager();
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400,"msg" => "ERROR");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);
			$json = $request->get("json", null);
			$params = json_decode($json);

			if ($json != null) {

				$referencia = (isset($params->referencia)) ? $params->referencia : null;
				$detalleObj = (isset($params->detalleobj)) ? $params->detalleobj : null;
				$estado = (isset($params->estado)) ? $params->estado : 1;
				$valor = (isset($params->valor)) ? $params->valor : null;
				$envio = (isset($params->envio)) ? $params->envio : null;
				$idUsuario = ($identity->sub != null) ? $identity->sub : null;
				$cuponId = (isset($params->cupon)) ? $params->cupon : null;
				$fechaCreado = new \Datetime("now");

				$cupon = $em->getRepository("BackBundle:Cupon")->findOneBy(array(
					"titulo" => $cuponId
				));

				$usuario = $em->getRepository("BackBundle:Usuario")->findOneBy(array(
					"idusuario" => $idUsuario
				));

				$pedido = new Pedido();
				$pedido->setReferencia($referencia);
				$pedido->setDetalleobj($detalleObj);
				$pedido->setFechacreado($fechaCreado);
				$pedido->setEstado($estado);
				$pedido->setValor($valor);
				$pedido->setEnvio($envio);
				$pedido->setIdusuario($usuario);

				$cup = is_object($cupon) ? $cupon : null;
				$pedido->setIdcupon($cup);
				

				$em->persist($pedido);
				$em->flush();
				$data = array("code" => 200,"msg" => "Pedido creado.", "id" => $pedido->getIdpedido());

			}else{$data = array("code" => 400,"msg" => "Parametros invalidos.");}
		} else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}


	//EDITAR PEDIDOS
	public function editAction(Request $request) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400,"msg" => "ERROR");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);
			$json = $request->get("json", null);
			$params = json_decode($json);

			if ($json != null) {

				$idPedido = (isset($params->idpedido)) ? $params->idpedido : null;
				$estado = (isset($params->estado)) ? $params->estado : 1;
				$envio = (isset($params->envio)) ? $params->envio : null;

				$em = $this->getDoctrine()->getManager();

				$usuario = $em->getRepository("BackBundle:Usuario")->findOneBy(array(
					"idusuario" => $identity->sub
				));

				$pedido = $em->getRepository("BackBundle:Pedido")->findOneBy(array(
					"idpedido" => $idPedido
				));

				if(is_object($pedido)){

					$havePermition = false;
					if($identity->role > 1){$havePermition = true;}
					if($identity->sub == $pedido->getidUsuario()->getidUsuario()){$havePermition = true;}

					if($havePermition == true){

						if($identity->role > 1){
							$pedido->setEstado($estado);
							$pedido->setEnvio($envio);
						}

						$em->persist($pedido);
						$em->flush();
						$data = array("code" => 200,"msg" => "Pedido editado.");

					}else{$data = array("code" => 400,"msg" => "Este pedido no es tuyo.");}
				}else{$data = array("code" => 400,"msg" => "No se encontro un pedido con ese ID.");}
			}else{$data = array("code" => 400,"msg" => "Parametros invalidos.");}
		} else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}


	//ELIMINAR PEDIDO
	public function deleteAction(Request $request, $idPedido) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400, "msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);


			$em = $this->getDoctrine()->getManager();
			$usuario = $em->getRepository("BackBundle:Usuario")->findOneBy(array("idusuario" => $identity->sub));
			$pedido = $em->getRepository("BackBundle:Pedido")->findOneBy(array("idpedido" => $idPedido));

			if(is_object($pedido)){

				$havePermition = false;
				if($identity->role > 1){$havePermition = true;}
				if($identity->sub == $pedido->getidUsuario()->getidUsuario()){$havePermition = true;}

				if($havePermition == true){

					$em->remove($pedido);
					$em->flush();
					$data = array("code" => 200, "msg" => "Pedido eliminado.");

				}else{$data = array("code" => 400,"msg" => "Este pedido no es tuyo.");}
			} else {$data = array("code" => 400, "msg" => "No existe un pedido con ese ID.");}
		} else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}

	//ADMINISTRAR PEDIDO
	public function manageOrderPayuAction(Request $request) {
		$em = $this->getDoctrine()->getManager();
		$helpers = $this->get("app.helpers");
		$data = array("code" => 400, "msg" => "Error");

		$token = $request->get("token", null);
		$accion = $request->get("accion", null);
		$referencia = $request->get("referencia", null);

		if ($token === "df336a36fc855a5f7bb46e9380366b16") {

			$pedido = $em->getRepository("BackBundle:Pedido")->findOneBy(array(
				"referencia" => $referencia
			));

			if(is_object($pedido)){

				if ($accion == 'delete') {
					$em->remove($pedido);
					$em->flush();
					$data = array("code" => 200,"msg" => "Pedido eliminado.");
				}

				if ($accion == 'validate') {
					$pedido->setEstado(3);
					$em->persist($pedido);
					$em->flush();
					$data = array("code" => 200,"msg" => "Pedido validado.");

					$emailUser = $pedido->getIdusuario()->getEmail();
					$cuerpo = '
					<style type="text/css">
					* { font-family: Verdana, Arial, sans-serif; }
					body { background-color: #fff; cursor: default; }
					</style>
					<h1>Hola' . $pedido->getIdusuario()->getNombres() .'</h1>
					<h1 style="text-align:center"><span style="color:#f60"><strong>¡El pago ha sido exitoso!</strong></span></h1>
					<p>La transacción correspondiente pedido <strong>Ref. <span style="color:#ff6600">' . $referencia . '</span></strong> fue <strong>APROBADA</strong>, Ahora tu pedido tiene estado <strong>En producción</strong> y se encuentra en proceso de imprenta, pronto te enviaremos un mensaje de confirmación a tu correo notificando el nuevo estado del pedido.
					</p>
					<br/>
					<h3 style="text-align: center; width:100%;background-color:#ff6600;padding:12px;color:white;"><strong>CONTACTO</strong></h3>
					<p><strong>Cristian Gartner</strong></p>
					<p><strong>Celular:</strong> 310 000 0000.</p>
					<p><strong>Email:</strong> virtualprintco@gmail.com.</p>
					<br/><br/>
					<h3 style="text-align: center;">¡Gracias por preferirnos!</h3>
					<br/>
					<p style="text-align: center;">
					<a href="http://virtualprint.co"><img src="http://virtualprint.co/gestor/assets/img/logo.png" alt="Virtual Print" width="250" height="70"></a>
					</p>
					';

					$message = \Swift_Message::newInstance()
					->setSubject('Confirmación de pago')
					->setFrom(array('virtualprintco@gmail.com' => 'Virtual Print'))
					->setTo($emailUser)
					->addPart($cuerpo, "text/html");
					$this->get('mailer')->send($message);

				}

			} else {
				$data = array("code" => 400, "msg" => "No existe un pedido con ese ID.");
			}
		} else {
			$data = array("code" => 400, "msg" => "Autorizacion invalida.");
		}
		return $helpers->json($data);
	}

}