<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackBundle\Entity\Inventario;
use BackBundle\Entity\Producto;

class InventarioController extends Controller {

	//LISTAR INVENTARIOS
	public function listAction( Request $request) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$identity = $helpers->authCheck($hash, true);
		$data = array("code" => 400, "msg" => "Error");

		if($authCheck == true && $identity->role > 1 ) {
			$repository = $this->getDoctrine()->getRepository('BackBundle:Inventario');
			$inventarios = $repository->findAll();
			$data = array("code" => 200, "msg" => "Inventarios listadas.", "data" => $inventarios);
		}else {$data = array("code" => 400, "msg" => "No autorizado.");}
		return $helpers->json($data);
	}


	//LISTAR INVENTARIO DE UN PRODUCTO
	public function viewAction(Request $request, $aliasProducto) {
		$helpers = $this->get("app.helpers");
		$data = array("code" => 400, "msg" => "Error");
		$em = $this->getDoctrine()->getManager();

		$producto = $em->getRepository("BackBundle:Producto")->findOneBy(array(
			"alias" => $aliasProducto
			));

		if (is_object($producto)) {

			$inventarios = $em->getRepository("BackBundle:Inventario")->findBy(array(
				"idproducto" => $producto->getIdproducto()
			));

			if(count($inventarios) > 0){
				$data = array("code" => 200, "msg" => "Inventarios listados", "data" => $inventarios);
			} else {$data = array("code" => 400, "msg" => "No existen inventarios de ese producto.");}
		} else {$data = array("code" => 400, "msg" => "No existe un producto con ese alias.");}
		return $helpers->json($data);
	}


	//CREAR INVENTARIO
	public function newAction(Request $request){
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400, "msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);
			$json = $request->get("json", null);

			if ($json != null) {
				$params = json_decode($json);

				if($identity->role > 1){

					$detalleObj = (isset($params->detalleobj)) ? $params->detalleobj : null;
					$idProducto = (isset($params->idproducto)) ? $params->idproducto : null;

					$em = $this->getDoctrine()->getManager();

					$producto = $em->getRepository("BackBundle:Producto")->findOneBy(array(
						"idproducto" => $idProducto
					));

					$invDeProd = $em->getRepository("BackBundle:Inventario")->findOneBy(array(
						"idproducto" => $producto
					));

					if($invDeProd == null || $idProducto == 1){

						if(is_object($producto)){

							$inventario = new Inventario();
							$inventario->setDetalleobj($detalleObj);
							$inventario->setIdproducto($producto);
							$em->persist($inventario);
							$em->flush();
							$data = array("code" => 200,"msg" => "Inventario creado.");

						}else{$data = array("code" => 400,"msg" => "No se encontro un producto con ese ID.");}
					}else{$data = array("code" => 400,"msg" => "Ese producto ya tiene asignado un inventario.");}
				}else{$data = array("code" => 400,"msg" => "No tienes permiso para crear inventarios.");}
			}else{$data = array("code" => 400,"msg" => "Parametros invalidos.");}
		} else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}


	//EDITAR INVENTARIO
	public function editAction(Request $request){
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400, "msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);
			$json = $request->get("json", null);

			if ($json != null) {
				$params = json_decode($json);

				if($identity->role > 1){

					$detalleObj = (isset($params->detalleobj)) ? $params->detalleobj : null;
					$idInventario = (isset($params->idinventario)) ? $params->idinventario : null;
					$idProducto = (isset($params->idproducto)) ? $params->idproducto : null;

					$em = $this->getDoctrine()->getManager();

					$inventario = $em->getRepository("BackBundle:Inventario")->findOneBy(array(
						"idinventario" => $idInventario
					));

					$producto = $em->getRepository("BackBundle:Producto")->findOneBy(array(
						"idproducto" => $idProducto
					));

					$invDeProd = $em->getRepository("BackBundle:Inventario")->findOneBy(array(
						"idproducto" => $producto
					));

					if($invDeProd == null || $idProducto == 1 || $inventario->getIdinventario() == $idInventario){

						if(is_object($inventario)){

							if($inventario->getidProducto()->getidProducto() != $idProducto && is_object($producto)){
								$inventario->setIdproducto($producto);
							}

							$inventario->setDetalleobj($detalleObj);
							$em->persist($inventario);
							$em->flush();
							$data = array("code" => 200,"msg" => "Inventario editado.");

						}else{$data = array("code" => 400,"msg" => "No se encontro una inventario con ese ID.");}
					}else{$data = array("code" => 400,"msg" => "Ese producto ya tiene asignada un inventario.");}
				}else{$data = array("code" => 400,"msg" => "No tienes permiso para editar inventarios.");}
			}else{$data = array("code" => 400,"msg" => "Parametros invalidos.");}
		} else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}


	//ELIMINAR INVENTARIO
	public function deleteAction(Request $request, $idInventario) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400, "msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);

			if ($identity->role > 1) {
				$em = $this->getDoctrine()->getManager();
				$inventario = $em->getRepository("BackBundle:Inventario")->findOneBy(array(
					"idinventario" => $idInventario
					));

				if(is_object($inventario)){
					$em->remove($inventario);
					$em->flush();
					$data = array("code" => 200, "msg" => "Inventario eliminado.");

				} else {$data = array("code" => 400, "msg" => "No existe una inventario con ese ID.");}
			} else {$data = array("code" => 400, "msg" => "No tienes permiso para eliminar inventarios.");}
		} else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}

}
