<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackBundle\Entity\Icono;

class IconoController extends Controller {

    //LISTAR ICONOS
    public function listAction( Request $request) {
        $helpers = $this->get("app.helpers");
        // $hash = $request->get("authorization", null);
        // $authCheck = $helpers->authCheck($hash);
        // $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400, "msg" => "Error");

        // if($authCheck == true && $identity->role > 1 ) {

            $repository = $this->getDoctrine()->getRepository('BackBundle:Icono');
            $iconos = $repository->findAll();
            $data = array("code" => 200, "msg" => "Iconos listados.", "data" => $iconos);

        // }else {$data = array("code" => 400, "msg" => "No autorizado.");}
        return $helpers->json($data);
    }

    //VER UN ICONO
    public function viewAction(Request $request, $idIcono) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400, "msg" => "Error");

         if($authCheck == true && $identity->role > 1 ) {

            $em = $this->getDoctrine()->getManager();
            $icono = $em->getRepository("BackBundle:Icono")->findOneBy(array("idicono" => $idIcono));

            if(is_object($icono)){

                $data = array("code" => 200, "msg" => "Icono listado.", "data" => $icono);

            } else {$data = array("code" => 400, "msg" => "No existe un icono con ese ID.");}

        } else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }


    //CREAR ICONO
    public function newAction(Request $request) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400,"msg" => "ERROR");

        if($authCheck == true && $identity->role > 1 ) {
            $json = $request->get("json", null);

            if ($json != null) {
                $params = json_decode($json);
                $titulo = (isset($params->titulo)) ? $params->titulo : null;
                $viewBox  = (isset($params->viewbox)) ? $params->viewbox : null;
                $codigo = (isset($params->codigo)) ? $params->codigo : null;

                if($titulo != null){

                    $em = $this->getDoctrine()->getManager();
                    $icono = $em->getRepository("BackBundle:Icono")->findOneBy(array(
                        "titulo" => $titulo
                    ));

                    if(!is_object($icono)){

                       $icono = new Icono();
                       $icono->setTitulo($titulo);
                       $icono->setViewbox($viewBox);
                       $icono->setCodigo($codigo);
                       $em = $this->getDoctrine()->getManager();
                       $em->persist($icono);
                       $em->flush();
                       $data = array("code" => 200,"msg" => "Icono creado.");

                    }else {$data = array("code" => 400,"msg" => "Ya existe un icono con ese titulo.");}
                } else {$data = array("code" => 400,"msg" => "Parametros incompletos.");}
            } else {$data = array("code" => 400,"msg" => "Parametros invalidos.");}
        } else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }


    //EDITAR ICONO
    public function editAction(Request $request) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400,"msg" => "ERROR");

        if($authCheck == true && $identity->role > 1 ) {
            $json = $request->get("json", null);
            if ($json != null) {
                $params = json_decode($json);
                $idIcono = (isset($params->idicono)) ? $params->idicono : null;
                $titulo = (isset($params->titulo)) ? $params->titulo : null;
                $viewBox  = (isset($params->viewbox)) ? $params->viewbox : null;
                $codigo = (isset($params->codigo)) ? $params->codigo : null;

                $em = $this->getDoctrine()->getManager();
                $icono = $em->getRepository("BackBundle:Icono")->findOneBy(array(
                    "idicono" => $idIcono
                ));

                $iconoT = $em->getRepository("BackBundle:Icono")->findOneBy(array(
                    "titulo" => $titulo
                ));

                if(!is_object($iconoT) || $icono->getTitulo() == $titulo){

                    if(is_object($icono)){

                        if($titulo != null){

                        $icono->setTitulo($titulo);
                        $icono->setViewbox($viewBox);
                        $icono->setCodigo($codigo);

                           $em->persist($icono);
                           $em->flush();
                           $data = array("code" => 200,"msg" => "Icono editado.");

                        } else {$data = array("code" => 400,"msg" => "Parametros incompletos.");}
                    } else {$data = array("code" => 400,"msg" => "No se encontro un icono con ese ID.");}
                } else {$data = array("code" => 400,"msg" => "Ya existe un icono con ese titulo.");}
            } else {$data = array("code" => 400,"msg" => "Parametros invalidos.");}
        } else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }


    //ELIMINAR ICONO
    public function deleteAction(Request $request, $idIcono) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400,"msg" => "ERROR");

         if($authCheck == true && $identity->role > 1 ) {
            $em = $this->getDoctrine()->getManager();
            $icono = $em->getRepository("BackBundle:Icono")->findOneBy(array(
                "idicono" => $idIcono
            ));

            if(is_object($icono)){

                $em->remove($icono);
                $em->flush();
                $data = array("code" => 200, "msg" => "Icono eliminado.");

            }else{$data = array("code" => 400,"msg" => "No se encontro un icono con ese ID.");}
        } else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }
}