<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackBundle\Entity\Usuario;
use BackBundle\Entity\Favorito;
use BackBundle\Entity\Plantilla;

class FavoritoController extends Controller {

	//LISTAR FAVORITOS
	public function listAction( Request $request){
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400,"msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);
			$json = $request->get("json", null);
			$em = $this->getDoctrine()->getManager();

			if ($json == null) {

				if($identity->role > 1){
					$repository = $this->getDoctrine()->getRepository('BackBundle:Favorito');
					$favoritos = $repository->findAll();

					if($favoritos) {
						foreach ($favoritos as $favorito){
							$dateSet = $favorito->getFechacreado()->format('M j, Y g:i:s A');
							$favorito->setFechacreado($dateSet);
						};
					}

					$data = array("code" => 200, "msg" => "Favoritos listados.", "data" => $favoritos);

				}else{$data = array("code" => 400, "msg" => "No tienes permisos para listar todos los favoritos.");}

			}else{

				$params = json_decode($json);
				$idUsuario = (isset($params->idusuario)) ? $params->idusuario : null;

				if($idUsuario != null){

					$favoritos = $em->getRepository("BackBundle:Favorito")->findBy(array(
						"idusuario" => $idUsuario
						));

					if($favoritos) {
						foreach ($favoritos as $favorito){
							$dateSet = $favorito->getFechacreado()->format('M j, Y g:i:s A');
							$favorito->setFechacreado($dateSet);
						};
					}

					$data = array("code" => 200,"msg" => "Favoritos del usuario logueado listados.", "data" => $favoritos);

				}else{$data = array("code" => 400,"msg" => "No se ha enviado un ID de usuario valido.");}
			}
		}else{$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}

	//LISTAR FAVORITOS DE UN USUARIO
	public function viewuserAction(Request $request, $idUsuario) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400, "msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);

			$em = $this->getDoctrine()->getManager();
			$favoritos = $em->getRepository("BackBundle:Favorito")->findBy(array(
				"idusuario" => $idUsuario
				));

			if(count($favoritos) > 0){

				$data = array("code" => 200, "msg" => "Favoritos listados", "data" => $favoritos);

			} else {$data = array("code" => 400, "msg" => "No existen favoritos de ese usuario.");}

		} else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}

	//VER UN FAVORITO
	public function viewAction(Request $request, $idFavorito) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400, "msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);

			$em = $this->getDoctrine()->getManager();
			$favorito = $em->getRepository("BackBundle:Favorito")->findOneBy(array(
				"idfavorito" => $idFavorito
				));

			if(is_object($favorito)){

				$havePermition = false;
				if ($identity->role > 1) {$havePermition = true;}
				if($identity->sub == $favorito->getidUsuario()->getidUsuario()){$havePermition = true;}

				if($havePermition == true){

					$dateSet = $favorito->getFechacreado()->format('M j, Y g:i:s A');
					$favorito->setFechacreado($dateSet);

					$data = array("code" => 200, "msg" => "Favorito listado.", "data" => $favorito);
				}else{$data = array("code" => 400, "msg" => "Este favorito no es tuyo.");}
			} else {$data = array("code" => 400, "msg" => "No existe un favorito con ese ID.");}
		} else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}


		//CREAR FAVORITOS
	public function newAction(Request $request) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400,"msg" => "ERROR");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);
			$json = $request->get("json", null);
			if ($json != null) {

				$params = json_decode($json);
				$color = (isset($params->color)) ? $params->color : null;
				$orientacion = (isset($params->orientacion)) ? $params->orientacion : null;
				$fechaCreado = new \Datetime("now");
				$idUsuario = ($identity->sub != null) ? $identity->sub : null;
				$idPlantilla = (isset($params->idplantilla)) ? $params->idplantilla : null;

				$em = $this->getDoctrine()->getManager();

				$plantilla = $em->getRepository("BackBundle:Plantilla")->findOneBy(array(
					"idplantilla" => $idPlantilla
					));

				$usuario = $em->getRepository("BackBundle:Usuario")->findOneBy(array(
					"idusuario" => $idUsuario
					));

				if(is_object($plantilla) && $idUsuario != null){

					$favorito = new Favorito();
					$favorito->setColor($color);
					$favorito->setOrientacion($orientacion);
					$favorito->setFechacreado($fechaCreado);
					$favorito->setIdusuario($usuario);
					$favorito->setIdplantilla($plantilla);
					$em->persist($favorito);
					$em->flush();
					$data = array("code" => 200,"msg" => "Favorito creado.");

				}else{$data = array("code" => 400,"msg" => "No se encontro una plantilla con ese ID.");}
			}else{$data = array("code" => 400,"msg" => "Parametros invalidos.");}
		}else{$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}

		//EDITAR FAVORITOS
	public function editAction(Request $request) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400,"msg" => "ERROR");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);
			$json = $request->get("json", null);
			if ($json != null) {

				$params = json_decode($json);
				$idFavorito = (isset($params->idfavorito)) ? $params->idfavorito : null;
				$color = (isset($params->color)) ? $params->color : null;
				$orientacion = (isset($params->orientacion)) ? $params->orientacion : null;

				$em = $this->getDoctrine()->getManager();

				$favorito = $em->getRepository("BackBundle:Favorito")->findOneBy(array(
					"idfavorito" => $idFavorito
					));


				if(is_object($favorito)){

					if($identity->sub == $favorito->getidUsuario()->getidUsuario()){

						$favorito->setColor($color);
						$favorito->setOrientacion($orientacion);

						$em->persist($favorito);
						$em->flush();
						$data = array("code" => 200,"msg" => "Favorito editado.");

					}else{$data = array("code" => 400,"msg" => "Este favorito no es tuyo.");}
				}else{$data = array("code" => 400,"msg" => "No Se encontro un favorito con ese ID.");}
			}else{$data = array("code" => 400,"msg" => "Parametros invalidos.");}
		}else{$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}

	//ELIMINAR FAVORITO
	public function deleteAction(Request $request, $idFavorito) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400, "msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);

			$em = $this->getDoctrine()->getManager();
			$favorito = $em->getRepository("BackBundle:Favorito")->findOneBy(array("idfavorito" => $idFavorito));

			if(is_object($favorito)){

				if($identity->sub == $favorito->getidUsuario()->getidUsuario() || $identity->role > 1){

					$em->remove($favorito);
					$em->flush();
					$data = array("code" => 200, "msg" => "Favorito eliminado.");

				}else{$data = array("code" => 400,"msg" => "Este favorito no es tuyo.");}
			} else {$data = array("code" => 400, "msg" => "No existe un favorito con ese ID.");}
		} else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}

	//ELIMINAR FAVORITOS DESDE PLANTILLA
	public function delete2Action(Request $request) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400, "msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);
			$json = $request->get("json", null);
			if ($json != null) {

				$params = json_decode($json);
				$idPlantilla = (isset($params->idplantilla)) ? $params->idplantilla : null;
				$color = (isset($params->color)) ? $params->color : null;
				$orientacion = (isset($params->orientacion)) ? $params->orientacion : null;

				$em = $this->getDoctrine()->getManager();
				$usuario = $em->getRepository("BackBundle:Usuario")->findOneBy(array("idusuario" => $identity->sub));
				$plantilla = $em->getRepository("BackBundle:Plantilla")->findOneBy(array("idplantilla" => $idPlantilla));
				$favorito = $em->getRepository("BackBundle:Favorito")->findOneBy(array(
					"idusuario" => $usuario,
					"idplantilla" => $plantilla,
					"color" => $color,
					"orientacion" => $orientacion
				));

				if(is_object($favorito)){

					if($identity->sub == $favorito->getidUsuario()->getidUsuario() || $identity->role > 1){

						$em->remove($favorito);
						$em->flush();
						$data = array("code" => 200, "msg" => "Favorito eliminado.");

					}else{$data = array("code" => 400,"msg" => "Este favorito no es tuyo.");}
				} else {$data = array("code" => 400, "msg" => "No existe un favorito con ese ID.");}
			}else{$data = array("code" => 400,"msg" => "Parametros invalidos.");}
		} else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}
}