<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackBundle\Entity\Usuario;
use BackBundle\Entity\Diseno;
use BackBundle\Entity\Plantilla;

class DisenoController extends Controller {

	//LISTAR DISEÑOS
	public function listAction( Request $request){
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400,"msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);
			$json = $request->get("json", null);
			$em = $this->getDoctrine()->getManager();

			if ($json == null) {

				if($identity->role > 1){
					$repository = $this->getDoctrine()->getRepository('BackBundle:Diseno');
					$disenos = $repository->findAll();

					if($disenos) {
						foreach ($disenos as $diseno){
							$dateSet = $diseno->getFechacreado()->format('M j, Y g:i:s A');
							$diseno->setFechacreado($dateSet);
						};
					}

					$data = array("code" => 200, "msg" => "Disenos listados.", "data" => $disenos);

				}else{$data = array("code" => 400, "msg" => "No tienes permisos para listar todos los disenos.");}

			}else{

				$params = json_decode($json);
				$idUsuario = (isset($params->idusuario)) ? $params->idusuario : null;

				if($idUsuario != null){

					$disenos = $em->getRepository("BackBundle:Diseno")->findBy(array(
						"idusuario" => $idUsuario
						));
					$data = array("code" => 200,"msg" => "Disenos del usuario logueado listados.", "data" => $disenos);
				}else{$data = array("code" => 400,"msg" => "No se ha enviado un ID de usuario valido.");}
			}
		}else{$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}

	//LISTAR EL ULTIMO DISENO DE UN USUARIO
	public function lastOfUserAction(Request $request, $idUsuario) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400, "msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);

			$em = $this->getDoctrine()->getManager();

			$usuario = $em->getRepository("BackBundle:Usuario")->findOneBy(array("idusuario" => $idUsuario));

			$diseno = $em->getRepository("BackBundle:Diseno")->findOneBy(
				array('idusuario'=>$usuario),
				array('iddiseno' => 'DESC')
			);

			if(is_object($diseno)){

				$dateSet = $diseno->getFechacreado()->format('M j, Y g:i:s A');
				$diseno->setFechacreado($dateSet);
				$data = array("code" => 200, "msg" => "Diseno listado.", "data" => $diseno);

			} else {$data = array("code" => 400, "msg" => "No existen diseños para ese usuario.");}
		} else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}

	//LISTAR DISEÑOS DE USUARIO EN CARRITO
	public function carritoAction(Request $request, $idUsuario) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400, "msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);

			$em = $this->getDoctrine()->getManager();

			$usuario = $em->getRepository("BackBundle:Usuario")->findOneBy(array("idusuario" => $idUsuario));

			$disenos = $em->getRepository("BackBundle:Diseno")->findBy(
				array(
					'idusuario'=>$usuario,
					'carrito' => true
					)
				);

			if($disenos) {
				foreach ($disenos as $diseno){
					$dateSet = $diseno->getFechacreado()->format('M j, Y g:i:s A');
					$diseno->setFechacreado($dateSet);
				};

				$data = array("code" => 200, "msg" => "Disenos listado.", "data" => $disenos);

			} else {$data = array("code" => 400, "msg" => "No existe diseños en carrito para ese usuario.");}
		} else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}

	//ELIMINAR TODOS LOS DISEÑOS DEL CARRITO DE UN USUARIO
	public function emptycarritoAction(Request $request, $idUsuario) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400, "msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);

			$em = $this->getDoctrine()->getManager();

			$usuario = $em->getRepository("BackBundle:Usuario")->findOneBy(array("idusuario" => $idUsuario));

			$disenos = $em->getRepository("BackBundle:Diseno")->findBy(
				array(
					'idusuario'=>$usuario,
					'carrito' => true
					)
				);

			if($disenos) {
				foreach ($disenos as $diseno) {
					$diseno->setCarrito(false);
					$em->persist($diseno);
				};
				$em->flush();

				$data = array("code" => 200, "msg" => "El carrito ha sido vaciado.", "data" => $disenos);

			} else {$data = array("code" => 400, "msg" => "No existe diseños en carrito para ese usuario.");}
		} else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}


	//VER UN DISEÑO
	public function viewAction(Request $request, $idDiseno) {
		$helpers = $this->get("app.helpers");
		$data = array("code" => 400, "msg" => "Error");
		$em = $this->getDoctrine()->getManager();
		$diseno = $em->getRepository("BackBundle:Diseno")->findOneBy(array(
			"iddiseno" => $idDiseno
		));

		if(is_object($diseno)){

			$dateSet = $diseno->getFechacreado()->format('M j, Y g:i:s A');
			$diseno->setFechacreado($dateSet);

			$data = array("code" => 200, "msg" => "Diseno listado.", "data" => $diseno);

		} else {$data = array("code" => 400, "msg" => "No existe un diseno con ese ID.");}
		return $helpers->json($data);
	}


	//ELIMINAR UN DISEÑO DEL CARRITO
	public function eliminardelcarritoAction(Request $request, $idDiseno) {

		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400, "msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);

			$em = $this->getDoctrine()->getManager();

			$diseno = $em->getRepository("BackBundle:Diseno")->findOneBy(array(
				"iddiseno" => $idDiseno
			));

			if(is_object($diseno)){

				$diseno->setCarrito(false);
				$em->persist($diseno);
				$em->flush();

				$data = array("code" => 200, "msg" => "Diseno eliminado del carrito.", "data" => $diseno);

			} else {$data = array("code" => 400, "msg" => "No existe un diseno con ese ID.");}
		} else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}


	//LISTAR DISEÑOS DE UN USUARIO
	public function viewuserAction(Request $request, $idUsuario) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400, "msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);

			$em = $this->getDoctrine()->getManager();
			$disenos = $em->getRepository("BackBundle:Diseno")->findBy(array(
				"idusuario" => $idUsuario
			));

			if(count($disenos) > 0){

				$data = array("code" => 200, "msg" => "Diseños listados", "data" => $disenos);

			} else {$data = array("code" => 400, "msg" => "No existen diseños de ese usuario.");}

		} else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}


	//CREAR DISEÑOS
	public function newAction(Request $request) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400,"msg" => "ERROR");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);
			$json = $request->get("json", null);
			if ($json != null) {

				$params = json_decode($json);
				$detalleObj = (isset($params->detalleobj)) ? $params->detalleobj : null;
				$carObj = (isset($params->carobj)) ? $params->carobj : null;
				$browser = (isset($params->browser)) ? $params->browser : null;
				$carrito = (isset($params->carrito)) ? $params->carrito : false;
				$fechaCreado = new \Datetime("now");
				$idUsuario = (isset($params->idusuario)) ? $params->idusuario : null;
				$idPlantilla = (isset($params->idplantilla)) ? $params->idplantilla : null;

				$em = $this->getDoctrine()->getManager();

				$plantilla = $em->getRepository("BackBundle:Plantilla")->findOneBy(array(
					"idplantilla" => $idPlantilla
					));

				$usuario = $em->getRepository("BackBundle:Usuario")->findOneBy(array(
					"idusuario" => $idUsuario
					));

				if(is_object($plantilla) && $idUsuario != null){

					$diseno = new Diseno();
					$diseno->setDetalleobj($detalleObj);
					$diseno->setCarobj($carObj);
					$diseno->setBrowser($browser);
					$diseno->setFechacreado($fechaCreado);
					$diseno->setCarrito($carrito);
					$diseno->setIdusuario($usuario);
					$diseno->setIdplantilla($plantilla);
					$em->persist($diseno);
					$em->flush();
					$data = array("code" => 200,"msg" => "Diseno creado.");

				}else{$data = array("code" => 400,"msg" => "No se encontro una plantilla con ese ID.");}
			}else{$data = array("code" => 400,"msg" => "Parametros invalidos.");}
		}else{$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}


	//EDITAR DISEÑOS
	public function editAction(Request $request) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400,"msg" => "ERROR");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);
			$json = $request->get("json", null);
			if ($json != null) {

				$params = json_decode($json);
				$idDiseno = (isset($params->iddiseno)) ? $params->iddiseno : null;
				$detalleObj = (isset($params->detalleobj)) ? $params->detalleobj : null;
				$carObj = (isset($params->carobj)) ? $params->carobj : null;
				$browser = (isset($params->browser)) ? $params->browser : null;
				$carrito = (isset($params->carrito)) ? $params->carrito : false;

				$em = $this->getDoctrine()->getManager();

				$diseno = $em->getRepository("BackBundle:Diseno")->findOneBy(array(
					"iddiseno" => $idDiseno
					));


				if(is_object($diseno)){

					if($identity->sub == $diseno->getidUsuario()->getidUsuario() || $identity->role > 1){

						$diseno->setDetalleobj($detalleObj);
						$diseno->setCarobj($carObj);
						$diseno->setBrowser($browser);
						$diseno->setCarrito($carrito);

						$em->persist($diseno);
						$em->flush();
						$data = array("code" => 200,"msg" => "Diseno editado.");

					}else{$data = array("code" => 400,"msg" => "Este diseno no es tuyo.");}
				}else{$data = array("code" => 400,"msg" => "No se encontro un diseno con ese ID.");}
			}else{$data = array("code" => 400,"msg" => "Parametros invalidos.");}
		}else{$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}


	//ELIMINAR DISEÑO
	public function deleteAction(Request $request, $idDiseno) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400, "msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);

			$em = $this->getDoctrine()->getManager();
			$diseno = $em->getRepository("BackBundle:Diseno")->findOneBy(array("iddiseno" => $idDiseno));

			if(is_object($diseno)){

				if($identity->sub == $diseno->getidUsuario()->getidUsuario() || $identity->role > 1){

					$ruta = "uploads/imagenes/disenos/".$identity->sub."/".$idDiseno;
					if (file_exists($ruta)) {
						foreach(glob($ruta."/*.*") as $obj){unlink($obj);
						}
						rmdir($ruta);
					}

					$em->remove($diseno);
					$em->flush();
					$data = array("code" => 200, "msg" => "Diseno eliminado.");

				}else{$data = array("code" => 400,"msg" => "Este diseno no es tuyo.");}
			} else {$data = array("code" => 400, "msg" => "No existe Un diseno con ese ID.");}
		} else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}
}