<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackBundle\Entity\Usuario;
use BackBundle\Entity\Direccion;

class DireccionesController extends Controller {


   //LISTAR DIRECCIONES
	public function listAction( Request $request) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$identity = $helpers->authCheck($hash, true);
		$data = array("code" => 400, "msg" => "Error");

		if($authCheck == true && $identity->role > 1 ) {

			$repository = $this->getDoctrine()->getRepository('BackBundle:Direccion');
			$direcciones = $repository->findAll();
			$data = array("code" => 200, "msg" => "Direciones listadas.", "data" => $direcciones);

		}else {$data = array("code" => 400, "msg" => "No autorizado.");}
		return $helpers->json($data);
	}

	//VER UNA DIRECCION
	public function viewAction(Request $request, $idDireccion) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$identity = $helpers->authCheck($hash, true);
		$data = array("code" => 400, "msg" => "Error");

		if($authCheck == true && $identity->role > 1 ) {

			$em = $this->getDoctrine()->getManager();
			$direccion = $em->getRepository("BackBundle:Direccion")->findOneBy(array(
				"iddireccion" => $idDireccion
			));

			if(is_object($direccion)){

				$dateSet = $direccion->getFechacreado()->format('M j, Y g:i:s A');
				$direccion->setFechacreado($dateSet);


				$data = array("code" => 200, "msg" => "Direccion listada.", "data" => $direccion);

			} else {$data = array("code" => 400, "msg" => "No existe una direccion con ese ID.");}
		} else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}

	//LISTAR DIRECCIONES DE UN USUARIO
	public function viewuserAction(Request $request, $idUsuario) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400, "msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);

			$em = $this->getDoctrine()->getManager();
			$direcciones = $em->getRepository("BackBundle:Direccion")->findBy(array(
				"idusuario" => $idUsuario
			));

			if(count($direcciones) > 0){

				$data = array("code" => 200, "msg" => "Direcciones listadas", "data" => $direcciones);

			} else {$data = array("code" => 400, "msg" => "No existen direcciones de ese usuario.");}

		} else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}

	//SETEAR DIRECCION PRINCIPAL
	public function selectprincipalAction(Request $request, $idUsuario, $idDireccion) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400, "msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);

			$em = $this->getDoctrine()->getManager();

			$direcciones = $em->getRepository("BackBundle:Direccion")->findBy(array(
				"idusuario" => $idUsuario
			));

			$seCambio = false;

			foreach ($direcciones as $direccion){
				if ($direccion->getiddireccion() == $idDireccion) {
					$direccion->setPrincipal(true);
					$seCambio = true;
				} else {
					$direccion->setPrincipal(null);
				}
				$em->persist($direccion);
				$em->flush();
			}

			if ($seCambio == true) {
				$data = array("code" => 200, "msg" => "Se establecio una direccion principal.");
			}else{
				$data = array("code" => 400,"msg" => "No se ha establecido una direccion principal.");
			}

		} else {
			$data = array("code" => 400, "msg" => "Autorizacion invalida.");
		}
		return $helpers->json($data);
	}

	//CREAR DIRECCION
	public function newAction(Request $request) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400,"msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);
			$json = $request->get("json", null);

			if ($json != null) {
				$params = json_decode($json);
				$ciudad = (isset($params->ciudad)) ? $params->ciudad : null;
				$departamento = (isset($params->departamento)) ? $params->departamento : null;
				$fechaCreado = new \Datetime("now");
				$detalle = (isset($params->detalle)) ? $params->detalle : null;
				$telefono = (isset($params->telefono)) ? $params->telefono : null;
				$nota = (isset($params->nota)) ? $params->nota : null;
				$principal = (isset($params->principal)) ? $params->principal : null;
				$idUsuario = (isset($params->idusuario)) ? $params->idusuario : null;

				if($idUsuario != null && $identity->role > 1){
					$idUsuario = (isset($params->idusuario)) ? $params->idusuario : null;
				}else{
					$idUsuario = ($identity->sub != null) ? $identity->sub : null;
				}


				if ($idUsuario != null && $ciudad != null && $departamento != null && $detalle != null) {

					$em = $this->getDoctrine()->getManager();

					$usuario = $em->getRepository("BackBundle:Usuario")->findOneBy(array(
						"idusuario" => $idUsuario
					));

					$direcciones = $em->getRepository("BackBundle:Direccion")->findBy(array(
						"idusuario" => $idUsuario
					));

					$direccion = new Direccion();

					if (count($direcciones) > 0) {
						$direccion->setPrincipal(false);
					} else {
						$direccion->setPrincipal(true);
					}

					$direccion->setCiudad($ciudad);
					$direccion->setDepartamento($departamento);
					$direccion->setFechacreado($fechaCreado);
					$direccion->setDetalle($detalle);
					$direccion->setTelefono($telefono);
					$direccion->setNota($nota);
					$direccion->setIdusuario($usuario);
					$em->persist($direccion);
					$em->flush();

					$dirs = $em->getRepository("BackBundle:Direccion")->findBy(array(
						"idusuario" => $idUsuario
					));

					$data = array("code" => 200,"msg" => "Direccion creada.", "data" => $dirs, "dir" => $direccion);

				}else{$data = array("code" => 400,"msg" => "Parametros incompletos.");}
			} else {$data = array("code" => 400,"msg" => "Parametros invalidos.");}
		} else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}


	//EDITAR DIRECCION
	public function editAction(Request $request) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400,"msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);
			$json = $request->get("json", null);

			if ($json != null) {

				$params = json_decode($json);
				$idDireccion = (isset($params->iddireccion)) ? $params->iddireccion : null;
				$ciudad = (isset($params->ciudad)) ? $params->ciudad : null;
				$departamento = (isset($params->departamento)) ? $params->departamento : null;
				$detalle = (isset($params->detalle)) ? $params->detalle : null;
				$telefono = (isset($params->telefono)) ? $params->telefono : null;
				$nota = (isset($params->nota)) ? $params->nota : null;
				$principal = (isset($params->principal)) ? $params->principal : null;
				$idUsuario = ($identity->sub != null) ? $identity->sub : null;


				if ($idUsuario != null && $ciudad != null &&
					$departamento != null && $detalle != null) {
					$em = $this->getDoctrine()->getManager();
					$direccion = $em->getRepository("BackBundle:Direccion")->findOneBy(array(
						"iddireccion" => $idDireccion
					));

					if(is_object($direccion)){
						$havePermition = false;
						if(isset($identity->sub) && $identity->role > 2){$havePermition = true;}

						if(isset($identity->sub) && $identity->sub == $direccion->getidUsuario()->getidUsuario()){
							$havePermition = true;
						}

						if($havePermition == true){
							$direccion->setCiudad($ciudad);
							$direccion->setDepartamento($departamento);
							$direccion->setDetalle($detalle);
							$direccion->setTelefono($telefono);
							$direccion->setNota($nota);
							$direccion->setPrincipal($principal);
							$em->persist($direccion);
							$em->flush();
							$data = array("code" => 200,"msg" => "Direccion actualizada.");

						}else{$data = array("code" => 400,"msg" => "Esta direccion no es tuya.");}
					}else{$data = array("code" => 400,"msg" => "No se encontro una direccion con ese ID.");}
				}else{$data = array("code" => 400,"msg" => "Parametros incompletos.");}
			} else {$data = array("code" => 400,"msg" => "Parametros invalidos.");}
		} else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}


	 //ELIMINAR DIRECCION
	public function deleteAction(Request $request, $idDireccion) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400,"msg" => "Error");

		if ($authCheck == true) {
			$identity = $helpers->authCheck($hash, true);
			$em = $this->getDoctrine()->getManager();

			$direccion = $em->getRepository("BackBundle:Direccion")->findOneBy(array(
				"iddireccion" => $idDireccion
			));

			if(is_object($direccion)){

				$havePermition = false;
				if(isset($identity->sub) && $identity->role > 2){$havePermition = true;}
				if(isset($identity->sub) && $identity->sub == $direccion->getidUsuario()->getidUsuario()){$havePermition = true;}

				if($havePermition == true){

					$wasPpal = $direccion->getPrincipal();

					$em->remove($direccion);
					$em->flush();


					if ($wasPpal) {

						$newPpal = $em->getRepository("BackBundle:Direccion")->findOneBy(array(
							"idusuario" => $identity->sub
						));

						if (is_object($newPpal)) {
							$newPpal->setPrincipal(true);
							$em->persist($newPpal);
							$em->flush();
						}

					}

					$dirs = $em->getRepository("BackBundle:Direccion")->findBy(array(
						"idusuario" => $identity->sub
					));

					$data = array("code" => 200,"msg" => "Direccion eliminada.", "data" => $dirs);

				} else {$data = array("code" => 400,"msg" => "Esta direccion no es tuya.");}
			}else{$data = array("code" => 400,"msg" => "No se encontro una direccion con ese ID.");}
		} else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}
}
