<?php

namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackBundle\Entity\Usuario;

class DefaultController extends Controller{

	public function indexAction(Request $request)
	{
		// replace this example code with whatever you need
		return $this->render('default/index.html.twig', [
			'base_dir' => realpath($this->getParameter('kernel.root_dir').'/..'),
		]);
	}

	public function loginAction(Request $request){
		$helpers = $this->get("app.helpers");
		$jwt_auth = $this->get("app.jwt_auth");
		$json = $request->get("json", null);

		if($json != null){
			$params = json_decode($json);
			$email = (isset($params->email)) ? $params->email : null;
			$password = (isset($params->password)) ? $params->password : null;
			$getHash = (isset($params->gethash)) ? $params->gethash : null;

			$emailContraint = new Assert\Email();
			$emailContraint->message = "Error, Email Invalido";

			$validate_email = $this->get("validator")->validate($email, $emailContraint);

				//Cifrar password
			$pwd = hash('sha256', $password);

			if(count($validate_email) == 0 && $password != null){

				if($getHash == null){
					$signup = $jwt_auth->signup($email, $pwd);
				}else{
					$signup = $jwt_auth->signup($email, $pwd, true);
				}
				return new JsonResponse($signup);

			}else{return $helpers->json(array("code" => 400, "msg" => "Usuario o contraseña incorrectos."));}

		}else{return $helpers->json(array("code" => 400, "msg" => "Enviar Json con POST."));}

	}

	//SUBIR IMAGENES DESDE URL
	public function imgUrlAction( Request $request) {
		$helpers = $this->get("app.helpers");
		$json = $request->get("json", null);
		$params = json_decode($json);
		$data = array("code" => 400,"msg" => "Error");

		if($json != null) {

			$ruta = (isset($params->ruta)) ? $params->ruta : null;
			$url = (isset($params->url)) ? $params->url : null;
			$alto = (isset($params->alto)) ? $params->alto : null;
			$ancho = (isset($params->ancho)) ? $params->ancho : null;
			$Nombre = (isset($params->nombre)) ? $params->nombre : null;
			

			if (!file_exists($ruta)) {
				mkdir($ruta, 0777, true);
			}

			if($ruta != NULL  && $url != NULL && $Nombre != NULL) {

				$options['thumb_width'] = "300";
				$options['delay'] = '3000';
				$options['width'] = $ancho;
				$options['height'] = $alto;
				$options['ttl'] = "0";
				$options['force'] = 'true';

				// function urlbox($url, $args){
				// 	$URLBOX_APIKEY = "VVc8NZB4O0JektKD";
				// 	$URLBOX_SECRET = "9d79d1634abf41e98e982e6c305021d3";
				// 	$options['url'] = rawurlencode($url);
				// 	$options += $args;
				// 	foreach ($options as $key => $value) {$_parts[] = "$key=$value";}
				// 	$query_string = implode("&", $_parts);
				// 	$TOKEN = hash_hmac("sha1", $query_string, $URLBOX_SECRET);
				// 	return "http://api.urlbox.io/v1/$URLBOX_APIKEY/$TOKEN/png/?$query_string";
				// }

				function urlbox($url, $ancho, $alto){
					// $curl = curl_init();

					// curl_setopt_array($curl, array(
					//   CURLOPT_URL => "https://restpack.io/api/screenshot/v3/capture?url=".rawurlencode($url)."&json=true&fresh=true&format=jpg&delay=3200&width=".$ancho."&height=".$alto,
					//   CURLOPT_RETURNTRANSFER => true,
					//   CURLOPT_ENCODING => "",
					//   CURLOPT_MAXREDIRS => 10,
					//   CURLOPT_TIMEOUT => 30, 
					//   CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
					//   CURLOPT_CUSTOMREQUEST => "POST",
					//   CURLOPT_POSTFIELDS => "",
					//   CURLOPT_HTTPHEADER => array( 
					//     "x-access-token: UxUSwXm9ZRoNyqPcWCF1owRK0n2qxxb0BFcBLFFC04JpNgOE" 
					//   ),
					// ));

					// $response = curl_exec($curl);
					// $err = curl_error($curl);

					// curl_close($curl);

					// if ($err) {
					//   echo "cURL Error #:" . $err;
					// } else {
					//   echo $response;
					// }

					// return $response;

					
				}

				//$apicallUrl = urlbox($url, $ancho, $alto);
				// $array = explode('"', $apicallUrl);

				// var_dump($array);

				// $imagen = file_get_contents($array[5]);
				// file_put_contents($ruta."/".$Nombre.".png" , $imagen);

				function webshrinker_v2($access_key, $secret_key, $url, $options=array()) {
				    $options['key'] = $access_key;

				    $parameters = http_build_query($options);

				    $request = sprintf("thumbnails/v2/%s?%s", base64_encode($url), $parameters);
				    $hash = md5(sprintf("%s:%s", $secret_key, $request));

				    return "https://api.webshrinker.com/{$request}&hash={$hash}";
				}

				$access_key = "8G2hVmPSCoUKvNTR4IcP";
				$secret_key = "MxbobHnL1BKEKwQ2BaKo";

				$request = webshrinker_v2($access_key, $secret_key, $url, [
				    'size' => 'xlarge'
				]);

				// Initialize cURL and use pre-signed URL authentication
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, $request);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

				$image_data = curl_exec($ch);
				$status_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
				if ($status_code == 200) {
					file_put_contents($ruta."/".$Nombre.".png" , $image_data);
					$data = array("code" => 200, "msg" => "Imagen subida.", "info" => $image_data);
				} else {
					$data = array("code" => 400,"msg" => "ERROR screenshot.");
				}

			} else {$data = array("code" => 400,"msg" => "Parametros incompletos.");}
		} else {$data = array("code" => 400,"msg" => "Parametros invalidos.");}
		return $helpers->json($data);
	}


	//SUBIR IMAGENES CON BASE64
	public function imgAction( Request $request) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$identity = $helpers->authCheck($hash, true);
		$authCheck = $helpers->authCheck($hash);
		$em = $this->getDoctrine()->getManager();

		$json = $request->get("json", null);
		$params = json_decode($json);
		$data = array("code" => 400,"msg" => "Error");

		if($authCheck == true) {

			if($json != null) {

				$ruta = (isset($params->ruta)) ? $params->ruta : null;
				$nombre = (isset($params->nombre)) ? $params->nombre : null;
				$base64 = (isset($params->base64)) ? $params->base64 : null;

				if (!file_exists($ruta)) {
					mkdir($ruta, 0777, true);
				}

				if($ruta != NULL && $nombre != NULL && $base64 != NULL) {
					$baseFromJavascript = str_replace(' ', '+', $base64);
    				$base_to_php = explode(',', $baseFromJavascript);
					$dataFile = base64_decode($base_to_php[0]);
					$filepath = $ruta."/".$nombre.".png";
					file_put_contents($filepath, $dataFile);
					$data = array("code" => 200,"msg" => "Imagen subida.");
				} else {$data = array("code" => 400,"msg" => "Parametros incompletos.");}
			} else {$data = array("code" => 400,"msg" => "Parametros invalidos.");}
		} else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}

	//BORRAR OBJETO DEL SERVIDOR
	public function deleteObjAction(Request $request) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$data = array("code" => 400,"msg" => "ERROR");

		if ($authCheck == true) {

			$json = $request->get("json", null);

			if ($json != null) {
				$params = json_decode($json);
				$ruta = (isset($params->ruta)) ? $params->ruta : null;

				if (file_exists($ruta)){
					unlink($ruta);
					$data = array("code" => 200, "msg" => "Objeto eliminado.");
				}else {$data = array("code" => 400,"msg" => "La ruta no existe.");}

			} else {$data = array("code" => 400,"msg" => "Parametros invalidos.");}
		} else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}

	//ENVIAR MENSAJE
	public function sendMsgAction(Request $request) {
		$helpers = $this->get("app.helpers");
		$data = array("code" => 400, "msg" => "Error");
		$em = $this->getDoctrine()->getManager();
		$json = $request->get("json", null);
		$params = json_decode($json);

		$asunto = (isset($params->asunto)) ? $params->asunto : null;
		$destino = (isset($params->destino)) ? $params->destino : null;
		$cuerpo = (isset($params->cuerpo)) ? $params->cuerpo : null;

		if ($asunto != null && $destino != null && $cuerpo != null) {

			$message = \Swift_Message::newInstance()
			->setSubject($asunto)
			->setFrom(array('virtualprintco@gmail.com' => 'Virtual Print'))
			->setTo($destino)
			->addPart($cuerpo, "text/html");
			$this->get('mailer')->send($message);
			$data = array("code" => 200,"msg" => "Mensaje enviado correctamente.");

		}else{$data = array("code" => 400,"msg" => "Parametros incompletos.");}
		return $helpers->json($data);
	}


	//REESTABLECER PASSWORD
	public function reestablishPassAction(Request $request) {
		$helpers = $this->get("app.helpers");
		$data = array("code" => 400, "msg" => "Error");
		$em = $this->getDoctrine()->getManager();

			$json = $request->get("json", null);
			$params = json_decode($json);

			$email = (isset($params->email)) ? $params->email : null;

			if($email != null){

				//CREAR Y ALMACENAR NUEVA CONTRASEÑA
				$usuario = $em->getRepository("BackBundle:Usuario")->findOneBy(array(
					"email" => $email
				));

				if(is_object($usuario)){

					$caracteres = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
					$newPassword = '';
					for ($i = 0; $i < 10; ++$i){
						$newPassword .= substr($caracteres, (mt_rand() % strlen($caracteres)), 1);
					}

					$newPasswordHash = hash('sha256', $newPassword);

					$usuario->setPassword($newPasswordHash);
					$em->persist($usuario);
					$em->flush();

					$message = \Swift_Message::newInstance()
					->setSubject('Reestablecimiento de contraseña')
					->setFrom(array('virtualprintco@gmail.com' => 'Virtual Print'))
					->setTo($usuario->getEmail())
					->addPart("<h2>Hola ".$usuario->getNombres()." !</h2>
						<h4>Tu contraseña ha sido reestablecida por <span style='color:#f60;'>".$newPassword."</span>. Ahora puedes ingresar a <a href='http://virtualprint.co/'>VirtualPrint.co</a>.</h4>", "text/html");
					$this->get('mailer')->send($message);

					$data = array("code" => 200,"msg" => "Mensaje enviado correctamente.", "pass" => $newPassword);
				} else {$data = array("code" => 400, "msg" => "No existe un usuario con ese Email");}
					}else{$data = array("code" => 400,"msg" => "Parametros incompletos.");}

		return $helpers->json($data);
	}

}

