<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackBundle\Entity\Decorador;

class DecoradorController extends Controller {

    //LISTAR DECORADORES
    public function listAction( Request $request) {
        $helpers = $this->get("app.helpers");
        $data = array("code" => 400, "msg" => "Error");

        $repository = $this->getDoctrine()->getRepository('BackBundle:Decorador');
        $decoradores = $repository->findAll();
        $data = array("code" => 200, "msg" => "Decoradores listados.", "data" => $decoradores);

        return $helpers->json($data);
    }

    //VER UN DECORADOR
    public function viewAction(Request $request, $idDecorador) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400, "msg" => "Error");

         if($authCheck == true && $identity->role > 1 ) {

            $em = $this->getDoctrine()->getManager();
            $decorador = $em->getRepository("BackBundle:Decorador")->findOneBy(array(
                "iddecorador" => $idDecorador
            ));

            if(is_object($decorador)){

                $data = array("code" => 200, "msg" => "Decorador listado.", "data" => $decorador);

            } else {$data = array("code" => 400, "msg" => "No existe Un decorador con ese ID.");}
        } else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }


    //CREAR DECORADOR
    public function newAction(Request $request) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400,"msg" => "ERROR");

        if($authCheck == true && $identity->role > 1 ) {
            $json = $request->get("json", null);

            if ($json != null) {
                $params = json_decode($json);
                $titulo = (isset($params->titulo)) ? $params->titulo : null;
                $viewBox  = (isset($params->viewbox)) ? $params->viewbox : null;
                $codigo = (isset($params->codigo)) ? $params->codigo : null;

                if($titulo != null){

                   $decorador = new Decorador();
                   $decorador->setTitulo($titulo);
                   $decorador->setViewbox($viewBox);
                   $decorador->setCodigo($codigo);
                   $em = $this->getDoctrine()->getManager();
                   $em->persist($decorador);
                   $em->flush();
                   $data = array("code" => 200,"msg" => "Decorador creado.");

                } else {$data = array("code" => 400,"msg" => "Parametros incompletos.");}
            } else {$data = array("code" => 400,"msg" => "Parametros invalidos.");}
        } else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }


    //EDITAR DECORADOR
    public function editAction(Request $request) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400,"msg" => "ERROR");

        if($authCheck == true && $identity->role > 1 ) {
            $json = $request->get("json", null);

            if ($json != null) {
                $params = json_decode($json);
                $idDecorador = (isset($params->iddecorador)) ? $params->iddecorador : null;
                $titulo = (isset($params->titulo)) ? $params->titulo : null;
                $viewBox  = (isset($params->viewbox)) ? $params->viewbox : null;
                $codigo = (isset($params->codigo)) ? $params->codigo : null;

                $em = $this->getDoctrine()->getManager();
                $decorador = $em->getRepository("BackBundle:Decorador")->findOneBy(array(
                    "iddecorador" => $idDecorador
                ));

                if(is_object($decorador)){

                    if($titulo != null){

                    $decorador->setTitulo($titulo);
                    $decorador->setViewbox($viewBox);
                    $decorador->setCodigo($codigo);

                       $em->persist($decorador);
                       $em->flush();
                       $data = array("code" => 200,"msg" => "Decorador editado.");

                    } else {$data = array("code" => 400,"msg" => "Parametros incompletos.");}
                } else {$data = array("code" => 400,"msg" => "No se encontro un decorador con ese ID.");}
            } else {$data = array("code" => 400,"msg" => "Parametros invalidos.");}
        } else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }


    //ELIMINAR DECORADOR
    public function deleteAction(Request $request, $idDecorador) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400,"msg" => "ERROR");

         if($authCheck == true && $identity->role > 1 ) {
            $em = $this->getDoctrine()->getManager();
            $decorador = $em->getRepository("BackBundle:Decorador")->findOneBy(array(
                "iddecorador" => $idDecorador
            ));

            if(is_object($decorador)){

                $em->remove($decorador);
                $em->flush();
                $data = array("code" => 200, "msg" => "Decorador eliminado.");

            }else{$data = array("code" => 400,"msg" => "No se encontro un decorador con ese ID.");}
        } else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }
}