<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackBundle\Entity\Cupon;

class CuponController extends Controller {

    //LISTAR CUPONES
    public function listAction( Request $request) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);

        if($authCheck == true) {
            $repository = $this->getDoctrine()->getRepository('BackBundle:Cupon');
            $cupones = $repository->findAll();
            $data = array("code" => 200, "msg" => "Cupones listados.", "data" => $cupones);

        }else {$data = array("code" => 400, "msg" => "No autorizado.");}
        return $helpers->json($data);
    }


    //VER UN CUPÓN
    public function viewAction(Request $request, $idCupon) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400, "msg" => "Error");

         if($authCheck == true && $identity->role > 1 ) {

            $em = $this->getDoctrine()->getManager();
            $cupon = $em->getRepository("BackBundle:Cupon")->findOneBy(array("idcupon" => $idCupon));

            if(is_object($cupon)){

                $data = array("code" => 200, "msg" => "Cupon listado.", "data" => $cupon);

            } else {$data = array("code" => 400, "msg" => "No existe un cupon con ese ID.");}

        } else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }

     //VER UN CUPÓN CON TITULO
    public function viewtitleAction(Request $request, $tituloCupon) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400, "msg" => "Error");

         if($authCheck == true && $identity->role > 1 ) {

            $em = $this->getDoctrine()->getManager();
            $cupon = $em->getRepository("BackBundle:Cupon")->findOneBy(array("titulo" => $tituloCupon));

            if(is_object($cupon)){

                $data = array("code" => 200, "msg" => "Cupon listado.", "data" => $cupon);

            } else {$data = array("code" => 400, "msg" => "No existe un cupon con ese titulo.");}

        } else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }

     //DESACTIVAR UN CUPON
    public function disarmAction(Request $request, $idCupon) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400, "msg" => "Error");

         if($authCheck == true) {

            $em = $this->getDoctrine()->getManager();
            $cupon = $em->getRepository("BackBundle:Cupon")->findOneBy(array("idcupon" => $idCupon));

            if(is_object($cupon)){

                $cupon->setEstado(false);
                $em->persist($cupon);
                $em->flush();

                $data = array("code" => 200, "msg" => "Cupon desactivado.", "data" => $cupon);

            } else {$data = array("code" => 400, "msg" => "No existe un cupon con ese titulo.");}

        } else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }


    //CREAR CUPONES
    public function newAction(Request $request) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $data = array("code" => 400,"msg" => "ERROR");

        if ($authCheck == true) {
            $identity = $helpers->authCheck($hash, true);
            $json = $request->get("json", null);

            if($identity->role > 1){
                $params = json_decode($json);

                if ($json != null) {

                    $titulo = (isset($params->titulo)) ? $params->titulo : null;
                    $tipo = (isset($params->tipo)) ? $params->tipo : null;
                    $estado = (isset($params->estado)) ? $params->estado : 1;
                    $valor = (isset($params->valor)) ? $params->valor : null;

                    $em = $this->getDoctrine()->getManager();
                    $cuponR = $em->getRepository("BackBundle:Cupon")->findOneBy(array(
                        "titulo" => $titulo
                    ));

                    if(!is_object($cuponR)){

                        if($titulo != null){

                            $cupon = new Cupon();
                            $cupon->setTitulo($titulo);
                            $cupon->setTipo($tipo);
                            $cupon->setEstado($estado);
                            $cupon->setValor($valor);

                            $em = $this->getDoctrine()->getManager();
                            $em->persist($cupon);
                            $em->flush();
                            $data = array("code" => 200,"msg" => "Cupon Creado.");

                        }else{$data = array("code" => 400,"msg" => "No se enviaron los parametros necesarios.");}
                    }else {$data = array("code" => 400,"msg" => "Ya existe un cupon con ese titulo.");}
                }else{$data = array("code" => 400,"msg" => "Parametros invalidos.");}
            }else{$data = array("code" => 400,"msg" => "No tienes permisos para crear cupones.");}
        } else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
         return $helpers->json($data);
    }


     //EDITAR CUPONES
    public function editAction(Request $request) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $data = array("code" => 400,"msg" => "ERROR");

        if ($authCheck == true) {
            $identity = $helpers->authCheck($hash, true);
            $json = $request->get("json", null);

            if($identity->role > 1){
                $params = json_decode($json);

                if ($json != null) {

                    $idCupon = (isset($params->idcupon)) ? $params->idcupon : null;
                    $titulo = (isset($params->titulo)) ? $params->titulo : null;
                    $tipo = (isset($params->tipo)) ? $params->tipo : null;
                    $estado = (isset($params->estado)) ? $params->estado : 1;
                    $valor = (isset($params->valor)) ? $params->valor : null;

                    if($titulo != null && $idCupon != null){

                        $em = $this->getDoctrine()->getManager();
                        $cupon = $em->getRepository("BackBundle:Cupon")->findOneBy(array(
                        "idcupon" => $idCupon
                        ));

                        if(is_object($cupon)){
                            $cupon->setTitulo($titulo);
                            $cupon->setTipo($tipo);
                            $cupon->setEstado($estado);
                            $cupon->setValor($valor);

                            $em = $this->getDoctrine()->getManager();
                            $em->persist($cupon);
                            $em->flush();
                            $data = array("code" => 200,"msg" => "Cupon Editado");

                        }else{$data = array("code" => 400,"msg" => "No se encontro un cupon con ese ID.");}
                    }else{$data = array("code" => 400,"msg" => "No se enviaron los parametros necesarios.");}
                }else{$data = array("code" => 400,"msg" => "Parametros invalidos.");}
            }else{$data = array("code" => 400,"msg" => "No tienes permiso Para editar productos.");}
        } else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
         return $helpers->json($data);
    }


    //ELIMINAR CUPON
    public function deleteAction(Request $request, $idCupon) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $data = array("code" => 400,"msg" => "ERROR");

        if ($authCheck == true) {
            $identity = $helpers->authCheck($hash, true);
            $em = $this->getDoctrine()->getManager();
            $cupon = $em->getRepository("BackBundle:Cupon")->findOneBy(array(
                "idcupon" => $idCupon
            ));

            if(is_object($cupon)){

                if ($identity->role > 1){
                    $em->remove($cupon);
                    $em->flush();
                    $data = array("code" => 200, "msg" => "Cupon eliminado.");

                }else{$data = array("code" => 400,"msg" => "No tienes permiso para eliminar cupones.");}
            }else{$data = array("code" => 400,"msg" => "No se encontro un cupon con ese ID.");}
        } else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }
}
