<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackBundle\Entity\Configuracion;
 
class ConfiguracionController extends Controller {
    
    
    //LISTAR CONFIGURACIONES
    public function listAction( Request $request) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400, "msg" => "Error");

        if($authCheck == true && $identity->role > 1 ) {
            
            $repository = $this->getDoctrine()->getRepository('BackBundle:Configuracion');
            $configuraciones = $repository->findAll();
            $data = array("code" => 200, "msg" => "Configuraciones listadas.", "data" => $configuraciones);

        }else {$data = array("code" => 400, "msg" => "No autorizado.");}
        return $helpers->json($data);
    }
     
    //VER UNA CONFIGURACION
    public function viewAction(Request $request, $idConfiguracion) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400, "msg" => "Error");

         if($authCheck == true && $identity->role > 1 ) {

            $em = $this->getDoctrine()->getManager();
            $configuracion = $em->getRepository("BackBundle:Configuracion")->findOneBy(array("idconfiguracion" => $idConfiguracion));

            if(is_object($configuracion)){

                $data = array("code" => 200, "msg" => "Configuracion listada.", "data" => $configuracion); 

            } else {$data = array("code" => 400, "msg" => "No existe una configuracion con ese ID.");}   
            
        } else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }
    
   //CREAR CONFIGURACION
    public function newAction(Request $request) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400,"msg" => "ERROR");

        if($authCheck == true && $identity->role > 1 ) {
            $json = $request->get("json", null);
            
            if ($json != null) {
                $params = json_decode($json);
                $alias = (isset($params->alias)) ? $params->alias : null;
                $texto  = (isset($params->texto)) ? $params->texto : null;
                    
                $em = $this->getDoctrine()->getManager();
                $configuracion = $em->getRepository("BackBundle:Configuracion")->findOneBy(array(
                    "alias" => $alias
                ));
                
                if(!is_object($configuracion)){ 

                   $configuracion = new Configuracion(); 
                   $configuracion->setAlias($alias);
                   $configuracion->setTexto($texto);
                   
                   $em = $this->getDoctrine()->getManager();
                   $em->persist($configuracion);
                   $em->flush();
                   $data = array("code" => 200,"msg" => "Configuracion creada.");

                    }else {$data = array("code" => 400,"msg" => "Este alias ya esta en uso.");}
            } else {$data = array("code" => 400,"msg" => "Parametros invalidos.");}
        } else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }

    //EDITAR CUPONES
    public function editAction(Request $request) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $data = array("code" => 400,"msg" => "ERROR");

        if ($authCheck == true) {
            $identity = $helpers->authCheck($hash, true);
            $json = $request->get("json", null);
            
            if($identity->role > 1){
                $params = json_decode($json);
                
                if ($json != null) {
                    
                    $idConfiguracion = (isset($params->idconfiguracion)) ? $params->idconfiguracion : null;
                    $alias = (isset($params->alias)) ? $params->alias : null;
                    $texto  = (isset($params->texto)) ? $params->texto : null;
                        
                    $em = $this->getDoctrine()->getManager();

                    $configuracion = $em->getRepository("BackBundle:Configuracion")->findOneBy(array(
                    "idconfiguracion" => $idConfiguracion
                    ));

                    $configR = $em->getRepository("BackBundle:Configuracion")->findOneBy(array(
                    "alias" => $alias
                    ));

                    $difVal = false;
                    if(!is_object($configR) || $configuracion->getalias()== $alias){
                        $difVal = true;
                    }

                
                    if(is_object($configuracion)){ 

                        if($difVal == true){ 
                        
                            $configuracion->setAlias($alias);
                            $configuracion->setTexto($texto);

                            $em->persist($configuracion);
                            $em->flush();
                            $data = array("code" => 200,"msg" => "Configuracion editada");

                        }else {$data = array("code" => 400,"msg" => "Este alias ya esta en uso.");}
                         
                    }else{$data = array("code" => 400,"msg" => "No se encontro una configuracion con ese ID.");} 
                    
                }else{$data = array("code" => 400,"msg" => "Parametros invalidos.");}
            }else{$data = array("code" => 400,"msg" => "No tienes permiso Para editar productos.");} 
        } else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }

    //ELIMINAR CONFIGURACION
    public function deleteAction(Request $request, $idConfiguracion) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $data = array("code" => 400,"msg" => "ERROR");

        if ($authCheck == true) {
            $identity = $helpers->authCheck($hash, true);
            $em = $this->getDoctrine()->getManager();
            $configuracion = $em->getRepository("BackBundle:Configuracion")->findOneBy(array(
                "idconfiguracion" => $idConfiguracion
            ));
            
            if(is_object($configuracion)){
                
                if ($identity->role > 1){
                    $em->remove($configuracion);
                    $em->flush();
                    $data = array("code" => 200, "msg" => "Configuracion eliminada.");
                    
                }else{$data = array("code" => 400,"msg" => "No tienes permiso para eliminar configuraciones.");}
            }else{$data = array("code" => 400,"msg" => "No se encontro un configuracion con ese ID.");}  
        } else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    } 
}
