<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackBundle\Entity\Producto;
use BackBundle\Entity\Categoria;

class CategoriaController extends Controller {

    //LISTAR CATEGORIAS
    public function listAction( Request $request) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400, "msg" => "Error");

        if($authCheck == true && $identity->role > 1 ) {
            $repository = $this->getDoctrine()->getRepository('BackBundle:Categoria');
            $categorias = $repository->findAll();
            $data = array("code" => 200, "msg" => "Categorias listadas.", "data" => $categorias);

        }else {$data = array("code" => 400, "msg" => "No autorizado.");}
        return $helpers->json($data);
    }

    //LISTAR CATEGORIAS DE UN PRODUCTO
    public function viewAction(Request $request, $aliasProducto) {
        $helpers = $this->get("app.helpers");
        $data = array("code" => 400, "msg" => "Error");
        $em = $this->getDoctrine()->getManager();

        $producto = $em->getRepository("BackBundle:Producto")->findOneBy(array(
            "alias" => $aliasProducto
        ));

        if (is_object($producto)) {
            $categorias = $em->getRepository("BackBundle:Categoria")->findBy(array(
                "idproducto" => $producto->getIdproducto()
            ));

            if(count($categorias) > 0){
                $data = array("code" => 200, "msg" => "Categorias listadas", "data" => $categorias);
            } else {$data = array("code" => 400, "msg" => "No existen categorias de ese producto.");}
        } else {$data = array("code" => 400, "msg" => "No existe un producto con ese alias.");}
        return $helpers->json($data);
    }


    //CREAR CATEGORIA
    public function newAction(Request $request){
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $data = array("code" => 400, "msg" => "Error");

        if ($authCheck == true) {
            $identity = $helpers->authCheck($hash, true);
            $json = $request->get("json", null);

            if ($json != null) {
                $params = json_decode($json);

                if($identity->role > 1){

                    $detalleObj = (isset($params->detalleobj)) ? $params->detalleobj : null;
                    $idProducto = (isset($params->idproducto)) ? $params->idproducto : null;

                    $em = $this->getDoctrine()->getManager();
                    $producto = $em->getRepository("BackBundle:Producto")->findOneBy(array(
                        "idproducto" => $idProducto
                    ));

                    $catDeProd = $em->getRepository("BackBundle:Categoria")->findOneBy(array(
                        "idproducto" => $producto
                    ));

                    if($catDeProd == null || $idProducto == 1){

                        if(is_object($producto)){

                            $categoria = new Categoria();
                            $categoria->setDetalleobj($detalleObj);
                            $categoria->setIdproducto($producto);
                            $em->persist($categoria);
                            $em->flush();
                            $data = array("code" => 200,"msg" => "Categoria creada.");

                        }else{$data = array("code" => 400,"msg" => "No se encontro un producto con ese ID.");}
                    }else{$data = array("code" => 400,"msg" => "Ese producto ya tiene asignada un grupo de categorias.");}
                }else{$data = array("code" => 400,"msg" => "No tienes permiso para crear categorias.");}
            }else{$data = array("code" => 400,"msg" => "Parametros invalidos.");}
        } else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }


    //EDITAR CATEGORIA
     public function editAction(Request $request){
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $data = array("code" => 400, "msg" => "Error");

        if ($authCheck == true) {
            $identity = $helpers->authCheck($hash, true);
            $json = $request->get("json", null);

            if ($json != null) {
                $params = json_decode($json);

                if($identity->role > 1){

                    $detalleObj = (isset($params->detalleobj)) ? $params->detalleobj : null;
                    $idCategoria = (isset($params->idcategoria)) ? $params->idcategoria : null;
                    $idProducto = (isset($params->idproducto)) ? $params->idproducto : null;

                    $em = $this->getDoctrine()->getManager();
                    $categoria = $em->getRepository("BackBundle:Categoria")->findOneBy(array(
                        "idcategoria" => $idCategoria
                    ));

                    $producto = $em->getRepository("BackBundle:Producto")->findOneBy(array(
                        "idproducto" => $idProducto
                    ));

                     $catDeProd = $em->getRepository("BackBundle:Categoria")->findOneBy(array(
                        "idproducto" => $producto
                    ));

                    if($catDeProd == null || $idProducto == 1 || $categoria->getIdcategoria() == $idCategoria){

                        if(is_object($categoria)){

                            if($categoria->getidProducto()->getidProducto() != $idProducto && is_object($producto)){
                                $categoria->setIdproducto($producto);
                            }

                            $categoria->setDetalleobj($detalleObj);
                            $em->persist($categoria);
                            $em->flush();
                            $data = array("code" => 200,"msg" => "Categoria editada.");

                        }else{$data = array("code" => 400,"msg" => "No se encontro una categoria con ese ID.");}
                    }else{$data = array("code" => 400,"msg" => "Ese producto ya tiene asignada un grupo de categorias.");}
                }else{$data = array("code" => 400,"msg" => "No tienes permiso para editar categorias.");}
            }else{$data = array("code" => 400,"msg" => "Parametros invalidos.");}
        } else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }


    //ELIMINAR CATEGORIAS
    public function deleteAction(Request $request, $idCategoria) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $data = array("code" => 400, "msg" => "Error");

        if ($authCheck == true) {
            $identity = $helpers->authCheck($hash, true);

            if ($identity->role > 1) {
                $em = $this->getDoctrine()->getManager();
                $categoria = $em->getRepository("BackBundle:Categoria")->findOneBy(array(
                    "idcategoria" => $idCategoria
                ));

                if(is_object($categoria)){
                    $em->remove($categoria);
                    $em->flush();
                    $data = array("code" => 200, "msg" => "Categoria eliminada.");

                } else {$data = array("code" => 400, "msg" => "No existe una categoria con ese ID.");}
            } else {$data = array("code" => 400, "msg" => "No tienes permiso para eliminar categorias.");}
        } else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }

}
