<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackBundle\Entity\Calificacion;

class CalificacionController extends Controller {

	//LISTAR CALIFICACIONES
	public function listAction( Request $request) {
		$helpers = $this->get("app.helpers");
		$data = array("code" => 400, "msg" => "Error");
		$em = $this->getDoctrine()->getManager();

		$calificaciones = $em->getRepository("BackBundle:Calificacion")->findBy(array(
			"estado" => 1
		));

		if($calificaciones) {
			foreach ($calificaciones as $calificacion){
				$dateSet = $calificacion->getFechacreado()->format('M j, Y g:i:s A');
				$calificacion->setFechacreado($dateSet);
			};
		}

		$data = array("code" => 200, "msg" => "Publicaciones listadas.", "data" => $calificaciones);

		return $helpers->json($data);
	}

	//VER UNA CALIFICACION
	public function viewAction(Request $request, $idCalificacion) {

		$helpers = $this->get("app.helpers");
		$data = array("code" => 400, "msg" => "Error");

		$em = $this->getDoctrine()->getManager();
		$calificacion = $em->getRepository("BackBundle:Calificacion")->findOneBy(array(
			"idcalificacion" => $idCalificacion
		));

		if(is_object($calificacion)){
			$dateSet = $calificacion->getFechacreado()->format('M j, Y g:i:s A');
			$calificacion->setFechacreado($dateSet);
			$data = array("code" => 200, "msg" => "Calificacion listada.", "data" => $calificacion);
		} else {
			$data = array("code" => 400, "msg" => "No existe una calificacion con ese ID.");
		}

		return $helpers->json($data);
	}

	//VER UNA CALIFICACION POR PEDIDO
	public function viewbypedidoAction(Request $request, $idPedido) {

		$helpers = $this->get("app.helpers");
		$data = array("code" => 400, "msg" => "Error");
		$em = $this->getDoctrine()->getManager();

		$calificacion = $em->getRepository("BackBundle:Calificacion")->findOneBy(array(
			"idpedido" => $idPedido
		));

		if(is_object($calificacion)){
			$dateSet = $calificacion->getFechacreado()->format('M j, Y g:i:s A');
			$calificacion->setFechacreado($dateSet);
			$data = array("code" => 200, "msg" => "Calificacion listada.", "data" => $calificacion);
		} else {
			$data = array("code" => 400, "msg" => "No existe una calificacion para ese pedido.");
		}

		return $helpers->json($data);
	}


	//OBTENER PROMEDIO Y CANTIDADES
	public function promedioAction( Request $request) {
		$helpers = $this->get("app.helpers");
		$data = array("code" => 400, "msg" => "Error");
		$em = $this->getDoctrine()->getManager();

		$calificaciones = $em->getRepository("BackBundle:Calificacion")->findBy(array(
			"estado" => 1
		));

		$promedio = 0;

		if($calificaciones) {
			foreach ($calificaciones as $calificacion){
				$promedio += $calificacion->getCalificacion();
			};
		}

		$data = array("code" => 200, "msg" => "Promedio de publicaciones listadas.", "data" => $promedio/count($calificaciones), "cantidad"=> count($calificaciones));

		return $helpers->json($data);
	}


	//CREAR CALIFICACION
	public function newAction(Request $request) {

		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$identity = $helpers->authCheck($hash, true);
		$em = $this->getDoctrine()->getManager();
		$data = array("code" => 400,"msg" => "ERROR");

		if($authCheck == true && $identity->role > 1 ) {
			$json = $request->get("json", null);

			if ($json != null) {
				$params = json_decode($json);
				$idPedido = (isset($params->idpedido)) ? $params->idpedido : null;
				$valorCalificacion = (isset($params->calificacion)) ? $params->calificacion : null;
				$comentario = (isset($params->comentario)) ? $params->comentario : null;
				$estado = (isset($params->estado)) ? $params->estado : false;
				$fechaCreado = new \Datetime("now");

				if($idPedido != null){

					$calificacion = new Calificacion();
					$calificacion->setIdpedido($idPedido);
					$calificacion->setCalificacion($valorCalificacion);
					$calificacion->setComentario($comentario);
					$calificacion->setEstado($estado);
					$calificacion->setFechacreado($fechaCreado);

					$em->persist($calificacion);
					$em->flush();
					$data = array("code" => 200,"msg" => "Calificacion creada.");

				} else {$data = array("code" => 400,"msg" => "Parametros incompletos.");}
			} else {$data = array("code" => 400,"msg" => "Parametros invalidos.");}
		} else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}


	 //EDITAR PUBLICACION
	public function editAction(Request $request) {
		$helpers = $this->get("app.helpers");
		$hash = $request->get("authorization", null);
		$authCheck = $helpers->authCheck($hash);
		$identity = $helpers->authCheck($hash, true);
		$data = array("code" => 400,"msg" => "ERROR");

		if($authCheck == true && $identity->role > 1 ) {
			$json = $request->get("json", null);

			if ($json != null) {
				$params = json_decode($json);
				$idCalificacion = (isset($params->idcalificacion)) ? $params->idcalificacion : null;
				$estado = (isset($params->estado)) ? $params->estado : 0;

				$em = $this->getDoctrine()->getManager();
				$calificacion = $em->getRepository("BackBundle:Calificacion")->findOneBy(array(
					"idcalificacion" => $idCalificacion
				));

				if(is_object($calificacion)){

					$calificacion->setEstado($estado);

					$em->persist($calificacion);
					$em->flush();
					$data = array("code" => 200,"msg" => "Calificacion editada");

				} else {$data = array("code" => 400,"msg" => "No se encontro una calificacion con ese ID.");}
			} else {$data = array("code" => 400,"msg" => "Parametros invalidos.");}
		} else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
		return $helpers->json($data);
	}

}