<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackBundle\Entity\Blog;

class BlogController extends Controller {

    //LISTAR PUBLICACIONES
    public function listAction( Request $request) {
        $helpers = $this->get("app.helpers");
        $data = array("code" => 400, "msg" => "Error");

        $repository = $this->getDoctrine()->getRepository('BackBundle:Blog');
        $publicaciones = $repository->findAll();

        if($publicaciones) {
            foreach ($publicaciones as $publicacion){
                $dateSet = $publicacion->getFechacreado()->format('M j, Y g:i:s A');
                $publicacion->setFechacreado($dateSet);
            };
        }

        $data = array("code" => 200, "msg" => "Publicaciones listadas.", "data" => $publicaciones);

        return $helpers->json($data);
    }

    //VER UNA PUBLICACION
    public function viewAction(Request $request, $idPublicacion) {
        $helpers = $this->get("app.helpers");
        // $hash = $request->get("authorization", null);
        // $authCheck = $helpers->authCheck($hash);
        // $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400, "msg" => "Error");

         // if($authCheck == true && $identity->role > 1 ) {

            $em = $this->getDoctrine()->getManager();
            $publicacion = $em->getRepository("BackBundle:Blog")->findOneBy(array(
                "idpublicacion" => $idPublicacion
            ));

            if(is_object($publicacion)){

                $dateSet = $publicacion->getFechacreado()->format('M j, Y g:i:s A');
                $publicacion->setFechacreado($dateSet);


                $data = array("code" => 200, "msg" => "Publicacion listada.", "data" => $publicacion);

            } else {$data = array("code" => 400, "msg" => "No existe una publicacion con ese ID.");}
        // } else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }


    //CREAR PUBLICACION
    public function newAction(Request $request) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400,"msg" => "ERROR");

        if($authCheck == true && $identity->role > 1 ) {
            $json = $request->get("json", null);

            if ($json != null) {
                $params = json_decode($json);
                $titulo = (isset($params->titulo)) ? $params->titulo : null;
                $contenido = (isset($params->contenido)) ? $params->contenido : null;
                $imagen = (isset($params->imagen)) ? $params->imagen : null;
                $estado = (isset($params->estado)) ? $params->estado : 0;
                $fechaCreado = new \Datetime("now");


                if($titulo != null){

                   $nombreImg = $fechaCreado->format('Y-m-d_H-i-s');

                   if ($imagen != null) {
                    $baseFromJavascript = str_replace(' ', '+', $imagen);
                    $base_to_php = explode(',', $baseFromJavascript);
                    $data = base64_decode($base_to_php[1]);
                    $filepath = "uploads/imagenes/blog/publicaciones/" . $nombreImg . ".png";
                    file_put_contents($filepath, $data);
                }

                   $blog = new Blog();
                   $blog->setTitulo($titulo);
                   $blog->setContenido($contenido);
                   $blog->setImagen($nombreImg);
                   $blog->setEstado($estado);
                   $blog->setFechacreado($fechaCreado);
                   $em = $this->getDoctrine()->getManager();
                   $em->persist($blog);
                   $em->flush();
                   $data = array("code" => 200,"msg" => "Publicacion creada.");

                } else {$data = array("code" => 400,"msg" => "Parametros incompletos.");}
            } else {$data = array("code" => 400,"msg" => "Parametros invalidos.");}
        } else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }


    //EDITAR PUBLICACION
    public function editAction(Request $request) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400,"msg" => "ERROR");

        if($authCheck == true && $identity->role > 1 ) {
            $json = $request->get("json", null);

            if ($json != null) {
                $params = json_decode($json);
                $idPublicacion = (isset($params->idpublicacion)) ? $params->idpublicacion : null;
                $titulo = (isset($params->titulo)) ? $params->titulo : null;
                $contenido = (isset($params->contenido)) ? $params->contenido : null;
                $estado = (isset($params->estado)) ? $params->estado : 0;
                $imagen = (isset($params->imagen)) ? $params->imagen : null;

                $em = $this->getDoctrine()->getManager();
                $blog = $em->getRepository("BackBundle:Blog")->findOneBy(array(
                    "idpublicacion" => $idPublicacion
                ));


                if(is_object($blog)){

                    if($titulo != null){

                        if ($imagen != null) {
                            $nombreImg = $blog->getImagen();
                            $baseFromJavascript = str_replace(' ', '+', $imagen);
                            $base_to_php = explode(',', $baseFromJavascript);
                            $data = base64_decode($base_to_php[1]);
                            $filepath = "uploads/imagenes/blog/publicaciones/" . $nombreImg . ".png";
                            file_put_contents($filepath, $data);
                        }

                       $blog->setTitulo($titulo);
                       $blog->setContenido($contenido);
                       $blog->setEstado($estado);

                       $em->persist($blog);
                       $em->flush();
                       $data = array("code" => 200,"msg" => "Publicacion editada");

                    } else {$data = array("code" => 400,"msg" => "Parametros incompletos.");}
                } else {$data = array("code" => 400,"msg" => "No se encontro una publicacion con ese ID.");}
            } else {$data = array("code" => 400,"msg" => "Parametros invalidos.");}
        } else {$data = array("code" => 400, "msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }


    //ELIMINAR PUBLICACION
    public function deleteAction(Request $request, $idPublicacion) {
        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $authCheck = $helpers->authCheck($hash);
        $identity = $helpers->authCheck($hash, true);
        $data = array("code" => 400,"msg" => "ERROR");

         if($authCheck == true && $identity->role > 1 ) {
            $em = $this->getDoctrine()->getManager();
            $publicacion = $em->getRepository("BackBundle:Blog")->findOneBy(array(
                "idpublicacion" => $idPublicacion
            ));

            if(is_object($publicacion)){

                $em->remove($publicacion);
                $em->flush();
                $data = array("code" => 200, "msg" => "Publicacion eliminada.");

            }else{$data = array("code" => 400,"msg" => "No se encontro una publicacion con ese ID.");}
        } else {$data = array("code" => 400,"msg" => "Autorizacion invalida.");}
        return $helpers->json($data);
    }
}